#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт выключает private_auction на блоке и выставляет дефолтные dsps для него.

=cut

# common modules
use Carp;
use warnings;
use strict;
use feature 'say';

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use Utils::Logger qw(INFOF);

my @BLOCKS = (
    {id => 1, campaign_id => 161336},
    {id => 1, campaign_id => 248160},

    {id => 2, campaign_id => 161354},
    {id => 2, campaign_id => 248144},

    {id => 3, campaign_id => 143062},
    {id => 3, campaign_id => 248144},

    {id => 4, campaign_id => 143062},
    {id => 4, campaign_id => 143067},

    {id => 6, campaign_id => 143065},
);

main();

sub main {
    my $app = Application->new();
    $app->pre_run();
    {
        no warnings 'redefine';
        no strict 'refs';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }
    $app->set_cur_user({id => 0});

    for my $block (@BLOCKS) {
        INFOF "page_id: %d, id: %d", $block->{'campaign_id'}, $block->{'id'};
        my $model      = 'context_on_site_rtb';
        my $block_info = $app->{$model}->get_all(
            fields => ['adfox_block', 'show_video'],
            filter => {campaign_id => $block->{'campaign_id'}, id => $block->{'id'}},
        )->[0];

        my $dsp_data = $app->{$model}->get_default_dsps(
            {
                page_id         => $block->{campaign_id},
                private_auction => 0,
                show_video      => $block_info->{'show_video'},
                adfox_block     => $block_info->{'adfox_block'}
            }
        );
        my $dsps = [map {$_->{'id'}} @$dsp_data];
        $app->partner_db->_do(
"UPDATE `partner`.`$model` set `private_auction` = 0 WHERE `campaign_id` = $block->{campaign_id} AND `id` = $block->{id};"
        );
        $app->{$model}->block_dsps->save_dsps(
            {
                page_id  => $block->{campaign_id},
                block_id => $block->{'id'},
            },
            $dsps,
            product => $app->{$model}
        );
    }
    $app->post_run();
    say "#END";
}
