#!/usr/bin/perl

# common modules
use feature 'say';

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

use Utils::MonitoringUtils qw(send_to_graphite);

my $COMMON_OFFER_LAUNCH = '2019-01-11 13:13:25';

sub fill_hash_and_send_to_graphite {
    my ($statistics_not_full, $key) = @_;

    my %statistics_full = ();
    $statistics_full{$statistics_not_full->[0]->{'dt'}} = int($statistics_not_full->[0]->{'cnt'});

    foreach my $i (1 ... $#$statistics_not_full) {
        $statistics_not_full->[$i]->{'cnt'} += $statistics_not_full->[$i - 1]->{'cnt'};
        $statistics_full{$statistics_not_full->[$i]->{'dt'}} = $statistics_not_full->[$i]->{'cnt'};
    }

    my $start_date = (split(' ', $COMMON_OFFER_LAUNCH))[0];

    my $end_date = curdate(oformat => 'db');

    for (
        my $date = $start_date;
        compare_dates($date, $end_date, iformat1 => 'db', iformat2 => 'db') <= 0;
        $date = date_add($date, day => 1, iformat => 'db', oformat => 'db')
      )
    {
        $statistics_full{$date} = $statistics_full{date_add($date, day => -1, iformat => 'db', oformat => 'db')} // 0
          unless exists $statistics_full{$date};

        send_to_graphite(
            interval  => "one_day",
            path      => "CommonOffer.statistics.$key",
            value     => $statistics_full{$date},
            timestamp => trdate('db', 'sec', $date),
        );
    }
}

# main
sub main {
    my $app = Application->new();

    $app->pre_run();

    my $tmp_rights = $app->add_all_tmp_rights();

    my $common_offer_trans_new_adfox = $app->partner_db->query->select(
        table  => $app->partner_db->common_offer_allowed_users,
        fields => {cnt => {count => ['user_id']}, dt => {'date', ['accept_date']}},
        filter => [accept_date => 'IS NOT' => \undef],
      )->join(
        table   => $app->partner_db->user_adfox,
        fields  => [],
        filter  => [adfox_login => 'LIKE' => \'yandex_%'],
        join_on => [user_id => '=' => {user_id => $app->partner_db->common_offer_allowed_users}],
      )->group_by('dt')->get_all();

    my $common_offer_trans_link_with_adfox = $app->partner_db->query->select(
        table  => $app->partner_db->common_offer_allowed_users,
        fields => {cnt => {count => ['user_id']}, dt => {'date', ['accept_date']}},
        filter => [accept_date => 'IS NOT' => \undef],
      )->join(
        table   => $app->partner_db->user_adfox,
        fields  => [],
        filter  => [adfox_login => 'NOT LIKE' => \'yandex_%'],
        join_on => [user_id => '=' => {user_id => $app->partner_db->common_offer_allowed_users}],
      )->group_by('dt')->get_all();

    my $common_offer_trans_all = $app->partner_db->query->select(
        table  => $app->partner_db->common_offer_allowed_users,
        fields => {cnt => {count => ['user_id']}, dt => {'date', ['accept_date']}},
        filter => [accept_date => 'IS NOT' => \undef],
    )->group_by('dt')->get_all();

    my $common_offer_reg_new_adfox = $app->partner_db->query->select(
        table  => $app->partner_db->users,
        fields => {cnt => {count => ['id']}, dt => {'date', ['create_date']}},
        filter => ['AND', [[create_date => '>=' => \$COMMON_OFFER_LAUNCH], [has_common_offer => '=' => \1]]],
      )->join(
        table   => $app->partner_db->user_adfox,
        fields  => [],
        filter  => [adfox_login => 'LIKE' => \'yandex_%'],
        join_on => [user_id => '=' => {id => $app->partner_db->users}],
      )->group_by('dt')->get_all();

    my $common_offer_reg_link_with_adfox = $app->partner_db->query->select(
        table  => $app->partner_db->users,
        fields => {cnt => {count => ['id']}, dt => {'date', ['create_date']}},
        filter => ['AND', [[create_date => '>=' => \$COMMON_OFFER_LAUNCH], [has_common_offer => '=' => \1]]],
      )->join(
        table   => $app->partner_db->user_adfox,
        fields  => [],
        filter  => [adfox_login => 'NOT LIKE' => \'yandex_%'],
        join_on => [user_id => '=' => {id => $app->partner_db->users}],
      )->group_by('dt')->get_all();

    my $common_offer_reg = $app->partner_db->query->select(
        table  => $app->partner_db->users,
        fields => {cnt => {count => ['id']}, dt => {'date', ['create_date']}},
        filter => ['AND', [[create_date => '>=' => \$COMMON_OFFER_LAUNCH], [has_common_offer => '=' => \1]]],
    )->group_by('dt')->get_all();

    my $users_reg = $app->partner_db->query->select(
        table  => $app->partner_db->users,
        fields => {cnt => {count => ['id']}, dt => {'date', ['create_date']}},
        filter => [create_date => '>=' => \$COMMON_OFFER_LAUNCH]
    )->group_by('dt')->get_all();

    my %graphite_data = (
        common_offer_trans_new_adfox       => $common_offer_trans_new_adfox,
        common_offer_trans_link_with_adfox => $common_offer_trans_link_with_adfox,
        common_offer_trans_all             => $common_offer_trans_all,
        common_offer_reg_new_adfox         => $common_offer_reg_new_adfox,
        common_offer_reg_link_with_adfox   => $common_offer_reg_link_with_adfox,
        common_offer_reg                   => $common_offer_reg,
        users_reg                          => $users_reg,
    );

    foreach my $key (keys %graphite_data) {
        fill_hash_and_send_to_graphite($graphite_data{$key}, $key);
    }

    $app->post_run();
}

main();
__END__
