#!/usr/bin/perl

=head1 DESCRIPTION
Скрипт фиксит все excluded_domains и excluded_phones
=cut

# common modules
use feature 'say';

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use utf8;
use Application;

# main
sub main {
    my $app = Application->new();

    $app->pre_run();

    my $tmp_rights = $app->add_all_tmp_rights();

    my $phones = $app->partner_db->excluded_phones->get_all();

    foreach my $phone (@{$phones}) {
        my $normalized_phone = get_normalized_phone_or_error($phone->{'phone'});

        $app->partner_db->excluded_phones->edit($phone, {phone => $normalized_phone->{'ok'}})
          if $normalized_phone->{'ok'} ne $phone->{'phone'};
    }

    my $datas = $app->partner_db->query->select(
        table  => $app->partner_db->excluded_domains,
        fields => [qw(page_id domain)],
    )->get_all();

    my $page_id_to_domains = {};

    foreach my $data (@{$datas}) {
        push @{$page_id_to_domains->{$data->{'page_id'}}}, $data->{'domain'};
    }

    foreach my $page_id (keys %{$page_id_to_domains}) {
        my @array = @{$page_id_to_domains->{$page_id}};

        map {$_ = get_domain_or_error($_)->{'ok'}} @{$page_id_to_domains->{$page_id}};

        my $array_uniq = array_uniq($page_id_to_domains->{$page_id});

        next
          if scalar @{$array_uniq} == scalar @array
              && scalar @{arrays_intersection(\@array, $array_uniq)} == scalar @{$array_uniq};

        $page_id_to_domains->{$page_id} = $array_uniq;

        $app->partner_db->transaction(
            sub {
                $app->partner_db->excluded_domains->delete($app->partner_db->filter({page_id => $page_id}));

                foreach my $domain (@{$page_id_to_domains->{$page_id}}) {
                    $app->partner_db->_do(
                        "INSERT INTO excluded_domains(`page_id`, `domain`) VALUES ($page_id, '$domain')");
                }
            }
        );
    }

    $app->post_run();
}
main();
__END__
