#!/usr/bin/perl

use lib::abs qw(../../lib);

use qbit;
use Application;

my $input = {
    logins => [
        qw(
          intowowinnovationladops
          cheetah-yan
          fyber-gmbh
          appo-click
          ironsrc.com
          )
    ],
    pages =>
      [267651, 291180, 189453, 189454, 187863, 199366, 292755, 141522, 320799, 142221, 171889, 180299, 168095, 168097,],
    source => 'R-VF-337880-1',
};

my @add_fields = (
    'dsps',                      'video_performance_active', 'strategy',      'video_performance_cpm',
    'adfox_user_id',             'category_id',              'video_blocked', 'caption',
    'mincpm',                    'adfox_block',              'blind',         'max_duration',
    'articles',                  'geo',                      'video_cpm',     'video_active',
    'page_id',                   'category_path',            'video_motion',  'comment',
    'video_performance_blocked', 'alternative_code',         'brands'
);

my $app = get_app();

sub main {

    open my $fh, ">", "block_list_result.txt";
    $fh->autoflush(1);

    open my $fhc, ">", "block_list_custom.txt";
    $fhc->autoflush(1);

    open my $fhe, ">", "block_list_error.txt";
    $fhe->autoflush(1);

    my @list;
    push @list, @{get_block_by_logins($input->{logins})};
    push @list, @{get_block_by_pages($input->{pages})};

    my $make = 0;
    for my $block (@list) {
        my %data;
        @data{@add_fields} = @{$block}{@add_fields};
        $data{type} = 3;
        if ($block->{is_custom_bk_data}) {
            print $fhc sprintf "R-V-%d-%d\n", $block->{page_id}, $block->{id};
        }
        try {
            my $id = $app->video_an_site_fullscreen->add(%data);
            print $fh sprintf "R-V-%d-%d %s\n", $block->{page_id}, $block->{id}, $id;
        }
        catch {
            my $e = shift;
            print $fhe sprintf "FAIL: R-V-%d-%d %s\n", $block->{page_id}, $block->{id}, $e->message;
        };
    }
    warn "Done $make from " . scalar(@list) . "\n";
}

sub get_app {
    my $app = Application->new();
    $app->pre_run();

    my $user_id = 0;
    $app->set_cur_user({id => $user_id});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }
    return $app;
}

sub get_block_by_logins {
    my ($login) = @_;
    my $list = $app->video_an_site_instream->get_all(
        fields => ['*'],
        filter => [
            'AND',
            [
                ['login', 'IN', $login],
                ['page', 'MATCH', ['multistate', '=', 'not deleted']],
                ['multistate', '=', 'not deleted'],
            ]
        ],
    );
    return $list;
}

sub get_block_by_pages {
    my ($page) = @_;
    my $list = $app->video_an_site_instream->get_all(
        fields => ['*'],
        filter => [
            'AND',
            [
                ['page', 'MATCH', ['AND', [["page_id", "IN", $page], ['multistate', '=', 'not deleted'],]]],
                ['multistate', '=', 'not deleted'],
            ]
        ]
    );
    return $list;
}

main();
