#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

YT_TABLE_PATH="//home/partner/test/PI-15100"


#### 1. Create folder
yt create map_node $YT_TABLE_PATH --proxy=pythia


#### 2. BLOCK_COUNT
# block_count.tsv
# login   model   md5     type    blocks_count    public_ids
# a-dudych        context_on_site_rtb     7c2060897dafd564d5aa0cc8e0e4932d        all     1       ["R-A-382410-1"]


#### Create table
yt create table "$YT_TABLE_PATH/block_count" --attributes "{
    dynamic=%false;
    schema=[
        {name=login;type=string;sort_order=ascending};
        {name=model;type=string;sort_order=ascending};
        {name=md5;type=string;sort_order=ascending};
        {name=type;type=string};
        {name=blocks_count;type=uint64};
        {name=public_ids;type=string}
    ]
}" --proxy=pythia

#### Заливаем данные
tail -n+2 block_count.tsv \
  | LC_ALL=C sort -k1,1 -k2,2 -k3,3 \
  | yt write "$YT_TABLE_PATH/block_count" --format \
    '<columns=[login;  model;  md5;  type;  blocks_count;  public_ids];enable_type_conversion=%true>schemaful_dsv' \
    --proxy=pythia


#### 3. BLOCK_SETTINGS

# block_settings.tsv
# login   model   md5     type    json
# a-a-mezen       context_on_site_rtb     1f9c50c386a0d16e2a41ac93a845cdd3        articles        [{"cpm":90000,"id":"39"},{"cpm":90000,"id":"55"}]


#### Create table
yt create table "$YT_TABLE_PATH/block_settings" --attributes "{
    dynamic=%false;
    schema=[
        {name=login;type=string;sort_order=ascending};
        {name=model;type=string;sort_order=ascending};
        {name=md5;type=string;sort_order=ascending};
        {name=type;type=string};
        {name=json;type=string}
    ]
}" --proxy=pythia

#### Заливаем данные
tail -n+2 block_settings.tsv \
  | LC_ALL=C sort -k1,1 -k2,2 -k3,3 \
  | yt write "$YT_TABLE_PATH/block_settings" --format \
    '<columns=[login;  model;  md5;  type;  json];enable_type_conversion=%true>schemaful_dsv' \
    --proxy=pythia
