#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

use Test::Deep qw(cmp_deeply);
use Test::More;
use Test::Differences;
use File::Slurp;
use JSON::XS;
use Data::Dumper;

my $fn1 = shift;
my $fn2 = shift;

my $f1 = sort_data(decode_json(read_file($fn1))->{data});
my $f2 = sort_data(decode_json(read_file($fn2))->{data});

is(scalar(@$f1), scalar(@$f2));

for my $i (0 .. $#$f1) {
    cmp_deeply($f1->[$i], $f2->[$i], "compare $i");
}

done_testing();

sub sort_data {
    my ($data) = @_;
    $data = [sort {$a->{id} <=> $b->{id}} @$data];
    for my $user (@$data) {
        my @pages;
        for my $page (sort {$a->{id} <=> $b->{id}} @{$user->{campaigns}}) {
            $page->{rtb_blocks} = [sort {$a->{id} <=> $b->{id}} @{$page->{rtb_blocks}}];
            for my $s (@{$page->{rtb_blocks}}) {
                if ($s->{sizes}) {
                    $s->{sizes} = [sort {$a->{width} <=> $b->{width} or $a->{height} <=> $b->{height}} @{$s->{sizes}}];
                }
            }
            push @pages, $page;
        }
        $user->{campaigns} = \@pages;
    }
    return $data;
}
