#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт правит cpm в поле articles для всех моделей

=head1 USAGE

  perl -I./lib ./bin/oneshots/PI-15721_fix_cpm_in_articles.pl
  perl -I./lib ./bin/oneshots/PI-15721_fix_cpm_in_articles.pl --page_ids=12312,534142

=head1 OPTIONS

  accessor - Аксессор модели
  page_ids - Список ID площадок через запятую (необязательный)

=cut

use qbit;

use Utils::ScriptWrapper;

use PiConstants qw($MAX_CPM);

my $LIMIT = 1000;

sub args {
    my ($opts) = @_;

    return ('accessor:s' => \$opts->{'accessor'}, 'page_ids:s' => \$opts->{'page_ids'});
}

run(
    sub {
        my ($app, $opts) = @_;

        my $dry = $opts->{'dry'};

        my @accessors = ();
        if ($opts->{'accessor'}) {
            push(@accessors, $opts->{'accessor'});
        } else {
            @accessors = grep {
                     $app->$_->DOES('Application::Model::Role::Has::Articles::FromField')
                  || $app->$_->DOES('Application::Model::Role::Has::Articles::FromRelatedModel')
            } @{$app->product_manager->get_block_model_accessors()};
        }

        my $page_ids = [];
        $page_ids = [split(/,/, $opts->{'page_ids'})] if defined($opts->{'page_ids'});

        foreach my $accessor (@accessors) {
            print logstr('MODEL:', $accessor);

            my $is_from_field = $app->$accessor->DOES('Application::Model::Role::Has::Articles::FromField');
            my $storage;
            if ($is_from_field) {
                $storage = $app->$accessor->storage_method_of_articles();
            }

            my $page_id_field_name = $app->$accessor->get_page_id_field_name();

            my $offset = 0;

            my $blocks = [];
            do {
                $blocks = $app->$accessor->get_all(
                    fields => [qw(page_id id data_articles), ($is_from_field ? () : 'opts')],
                    (@$page_ids ? (filter => {page_id => $page_ids}) : ()),
                    offset => $offset,
                    limit  => $LIMIT
                );

                foreach my $block (@$blocks) {
                    if ($block->{'data_articles'} && @{$block->{'data_articles'}}) {
                        my $data_articles = clone($block->{'data_articles'});
                        my $need_update   = FALSE;
                        foreach my $row (@$data_articles) {
                            if (defined($row->{'cpm'})) {
                                if ($row->{'cpm'} > $MAX_CPM) {
                                    $need_update = TRUE;

                                    $row->{'cpm'} = $MAX_CPM;
                                } elsif ($row->{'cpm'} < 1) {
                                    $need_update = TRUE;

                                    $row->{'cpm'} = 1;
                                }
                            }
                        }

                        if ($need_update) {
                            print logstr('UPDATE BLOCK:', $block);

                            print logstr('SET ARTICLES:', $data_articles);

                            if ($dry) {
                                next;
                            }

                            if ($is_from_field) {
                                if ($storage eq 'db') {
                                    $app->partner_db->$accessor->edit(
                                        {$page_id_field_name => $block->{'page_id'}, id => $block->{'id'}},
                                        {articles            => to_json($data_articles)});
                                } else {
                                    #opts

                                    my $block_opts = $block->{'opts'};
                                    $block_opts->{'articles'} = to_json($data_articles);

                                    $app->partner_db->$accessor->edit(
                                        {$page_id_field_name => $block->{'page_id'}, id => $block->{'id'}},
                                        {opts                => to_json($block_opts)});
                                }
                            } else {
                                # table articles
                                $app->partner_db->transaction(
                                    sub {
                                        $app->partner_db->articles->delete(
                                            $app->partner_db->filter(
                                                {page_id => $block->{'page_id'}, block_id => $block->{'id'}}
                                            )
                                        );

                                        $app->partner_db->articles->add_multi(
                                            [
                                                map {
                                                    {
                                                        page_id     => $block->{'page_id'},
                                                        block_id    => $block->{'id'},
                                                        article_sid => $_->{'id'},
                                                        cpm         => $_->{'cpm'}
                                                    }
                                                  } @$data_articles
                                            ]
                                        );
                                    }
                                );
                            }
                        }
                    }
                }

                $offset += $LIMIT;
            } while (@$blocks == $LIMIT);
        }
    }
   );
