#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе

    Добавляет на пейджи kp-team блоки c категорией VH:Другое

=head1 USAGE

    perl -I./lib ./bin/oneshots/PI-15887_add_blocks_with_vh_others_category_for_kp_team.pl
    perl -I./lib ./bin/oneshots/PI-15887_add_blocks_with_vh_others_category_for_kp_team.pl --previous_log=previous_log_name.log

=head1 OPTIONS

    previous_log - указать лог предыдущего запуска для избежания задвоения копируемых блоков
    (предварительно лог предыдущего запуска следует переименовать)

=cut

use qbit;
use Utils::ScriptWrapper;

my $kp_team_user_id = 369738908;

sub args {
    my ($opts) = @_;

    return ('previous_log:s' => \$opts->{'previous_log'});
}

run(
    sub {
        my ($app, $opts) = @_;

        $app->set_cur_user({id => 0, login => 'system-cron'});

        my $stash;
        if (defined $opts->{'previous_log'}) {
            my $content = readfile($opts->{'previous_log'});
            foreach my $log_line (split(/\n/, $content)) {
                next unless $log_line =~ /(\S+)\s+completed$/;
                $stash->{$1} = TRUE;
            }
        }

        my $pages = $app->video_an_site->get_all(
            fields => ['page_id'],
            filter => {owner_id => $kp_team_user_id, multistate => 'not (deleted or protected)'}
        );
        foreach my $page (@$pages) {
            print logstr("Processing page ", $page->{page_id});
            if ($stash->{$page->{page_id}}) {
                print logstr("Page ", $page, " already processed");
                next;
            }

            my $blocks = $app->video_an_site_instream->get_all(
                fields => ['*'],
                filter => {page_id => $page->{page_id}, category_id => 1013, multistate => 'not deleted'}
            );

            foreach my $block_settings (@$blocks) {

                if ($stash->{$block_settings->{public_id}}) {
                    print logstr("Block ", $block_settings->{public_id}, " already copied");
                    next;
                } else {
                    $app->partner_db->transaction(
                        sub {
                            print logstr("Copy block ", $block_settings->{public_id});
                            my $id        = $app->video_an_site_instream->on_action_duplicate($block_settings);
                            my $new_block = $app->video_an_site_instream->get_all(
                                fields => [qw(id page_id caption)],
                                filter => {public_id => $id->{public_id}}
                            )->[0];
                            my $caption = $new_block->{caption};
                            $caption =~ s/я\.{0,1}видео/другое/i;
                            $app->partner_db->video_an_site_instream->edit($new_block,
                                {category_id => 1017, caption => $caption});
                            print logstr($block_settings->{public_id}, " => ", $id->{public_id});
                            print logstr("Block ", $block_settings->{public_id}, " completed");

                        }
                    );
                }

            }
            print logstr("Page ", $page->{page_id}, " completed");

        }

    }
   );
