#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт выводит польз-лей, которые видят поля ФРОД в статистике

=head1 USAGE

  perl -I./lib ./bin/oneshots/PI-15917_users_seeing_stat_fraud.pl
  perl -I./lib ./bin/oneshots/PI-15917_users_seeing_stat_fraud.pl --level=statistics_video_an_site

=head1 OPTIONS

  level - уровень статистики (необязательный)

=cut

use feature qw/say/;

use qbit;
use Application::Model::Statistics::Fields::Types qw(@FIELD_TYPES);
use Utils::ScriptWrapper;

sub args {
    my ($opts) = @_;

    return ('level:s' => \$opts->{'level'},);
}

run(
    sub {
        my ($app, $opts) = @_;

        my %role_list;

        my $right2role = RoleRights->new('production')->get_rights();

        my @level_list = $opts->{level} ? ($opts->{level}) : @{$app->product_manager->get_statistics_accessors()};

        my %dependant_hh;
        for my $f (@FIELD_TYPES) {
            for (@{$f->{depends_on} // []}) {
                $dependant_hh{$_} = [] unless exists $dependant_hh{$_};
                push @{$dependant_hh{$_}}, $f->{id};
            }
        }

        foreach my $level (@level_list) {

            my $all_fields = $app->$level->fields();

            my %fields =
              map {$_ => $all_fields->{$_}}
              grep {$_ =~ /bad|fraud/ig && exists $all_fields->{$_}->{check_rights}} keys %$all_fields;

            for my $f (keys %fields) {
                next unless exists $dependant_hh{$f};
                for (@{$dependant_hh{$f}}) {
                    if (!(exists $fields{$_}) && (exists $all_fields->{$_}->{check_rights})) {
                        $fields{$f} = $all_fields->{$_};
                    }
                }
            }

            for my $f (keys %fields) {
                $role_list{$_}++ for keys %{$right2role->{$fields{$f}->{check_rights}}};
            }
        }

        my $user_list = $app->users->get_all(
            fields => [qw/id login/],
            filter => {role_id => [keys %role_list],},
        );

        say to_json($user_list, canonical => 1);

    }
   );
