#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт нуждается в подключении к PROD базе

Откатывает изменения сделанные ./bin/oneshots/PI-15979_poster_horizontal.pl

=head1 USAGE

  perl -I./lib ./bin/oneshots/PI-15979_rollback_poster_horizontal.pl --log=./PI-15979_poster_horizontal.out

=head1 OPTIONS

  log - Файл с логами

=cut

use qbit;

use Utils::ScriptWrapper;

my $HANDLERS = {'SETTINGS:' => \&rollback_changes,};

my %PAGE_IDS = ();

sub args {
    my ($opts) = @_;

    return ('log:s' => \$opts->{'log'}, 'page_ids:s' => \$opts->{'page_ids'},);
}

run(
    sub {
        my ($app, $opts) = @_;

        my $log = $opts->{'log'};

        die 'Expected: --log=./PI-15979_poster_horizontal.out' unless defined($log);

        open(my $fh, '<', $log) or die $!;

        while (my $line = <$fh>) {
            chomp($line);

            if ($line =~ /\d{4}-\d{2}-\d{2}\s\d{2}:\d{2}:\d{2}\s-\s([^\t]+)?\t(.+)/) {
                my $tag  = $1;
                my $data = $2;

                if (exists($HANDLERS->{$tag})) {
                    my @data = split(/\t/, $data);

                    $HANDLERS->{$tag}->($app, $opts, \@data);
                }
            }
        }

        my @uniq_page_ids = keys(%PAGE_IDS);

        print logstr('SEND_TO_BK:', scalar(@uniq_page_ids) . ' pages');

        $app->all_pages->mark_pages_for_async_update(page_ids => \@uniq_page_ids);
    }
   );

sub rollback_changes {
    my ($app, $opts, $row) = @_;

    my $dry_run = $opts->{'dry_run'};

    my $model = $row->[0];
    my $pk    = from_json($row->[1]);
    my $data  = from_json($row->[2]);

    my $key   = 'UPDATE:';
    my $error = '';

    unless ($dry_run) {
        try {
            $app->partner_db->transaction(
                sub {
                    my $block = $app->$model->get($pk, fields => [keys(%$data)], for_update => TRUE);

                    print logstr('SETTINGS:', $model, $pk, $block);

                    my $design_templates = delete($data->{'design_templates'});
                    $app->partner_db->$model->edit($pk, $data);
                    $data->{'design_templates'} = $design_templates;

                    $app->partner_db->design_templates->edit($_, {opts => $_->{'opts'}}) foreach @$design_templates;
                }
            );

            $PAGE_IDS{$pk->{'campaign_id'}} = TRUE;
        }
        catch {
            $key   = 'ERROR:';
            $error = shift->message();
        };
    }

    print logstr($key, $model, $pk, $data, $error);
}
