#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт правит cpm в поле articles для всех моделей

=head1 USAGE

  perl -I./lib ./bin/oneshots/PI-15986_turn_on_preload_option_for_all_inpage_blocks.pl
  perl -I./lib ./bin/oneshots/PI-15986_turn_on_preload_option_for_all_inpage_blocks.pl --page_ids=12312,534142
  perl -I./lib ./bin/oneshots/PI-15986_turn_on_preload_option_for_all_inpage_blocks.pl --log_to_revert=log_for_revert_changes.out

=head1 OPTIONS

  log_to_revert - Лог-файл предыдужего запуска скрипта для отката изменений (необязательный)
  page_ids - Список ID площадок через запятую (необязательный)

=cut

use qbit;

use Utils::ScriptWrapper;

my $BLACKLISTED_LOGINS = {
    238949518 => 'maximatelecom',
    524792934 => 'mediaforce-rtb'
};

sub args {
    my ($opts) = @_;

    return (
        'accessor:s'      => \$opts->{'accessor'},
        'page_ids:s'      => \$opts->{'page_ids'},
        'log_to_revert:s' => \$opts->{'log_to_revert'}
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        my $dry              = $opts->{'dry'};
        my $preload_value    = 1;
        my $blocks_to_modify = [];

        if (defined $opts->{'log_to_revert'}) {
            $preload_value = 0;
            my $content = readfile($opts->{'log_to_revert'});
            foreach my $log_line (split(/\n/, $content)) {
                next unless $log_line =~ /UPDATE BLOCK/;
                $log_line =~ s/.*({.*}).*/$1/;
                my $data = from_json($log_line);
                push @$blocks_to_modify,
                  {page_id => $data->{'page_id'}, id => $data->{'id'}, preload => 1 - $preload_value};
            }
        } else {
            my $page_ids = [];
            if (defined($opts->{'page_ids'})) {
                $page_ids = [split(/,/, $opts->{'page_ids'})];
            } else {
                my $pages = $app->video_an_site->get_all(
                    fields => ['id'],
                    filter => [
                        'AND',
                        [
                            {multistate => 'not protected and not deleted'},
                            ['owner_id', 'NOT IN', [keys %$BLACKLISTED_LOGINS]]
                        ]
                    ]
                );
                $page_ids = [map {$_->{'id'}} @$pages];
            }

            $blocks_to_modify = $app->video_an_site_inpage->get_all(
                fields => [qw(page_id id preload)],
                filter => ['AND', [{page_id => $page_ids}, {multistate => 'not deleted'}, {is_custom_bk_data => 0}]],
            );
        }
        foreach my $block (@$blocks_to_modify) {
            next if $block->{'preload'} == $preload_value;
            print logstr('UPDATE BLOCK:', $block);
            next if $dry;

            delete $block->{'preload'};
            try {
                $app->video_an_site_inpage->do_action($block, 'edit', 'preload', $preload_value);
            }
            catch {
                my ($e) = @_;
                print STDERR logstr('ERROR UPDATE', {block => $block, error => $e->message});
            };
        }
    }
   );
