use qbit;
use Utils::ScriptWrapper;

my $block_id_list = [
    [127621, 6],
    [127621, 8],
    [151334, 4],
    [161360, 1],
    [161360, 5],
    [161360, 6],
    [161360, 7],
    [161360, 8],
    [161360, 9],
    [161360, 10],
    [162377, 72],
    [164766, 2],
    [164766, 3],
    [208627, 2],
    [251611, 2]
];

run(
    sub {
        my ($app, $opts) = @_;

        my $block_list = $app->partner_db->context_on_site_rtb->get_all(
            "fields" => ["campaign_id", "id", "adfox_block", "adfox_user_id", "private_auction", "show_video"],
            "filter" =>
              ['OR', [map {['AND', [['campaign_id' => '=' => \$_->[0]], ['id' => '=' => \$_->[1]]]]} @$block_id_list]],
        );

        foreach my $block (@$block_list) {

            $app->partner_db->transaction(
                sub {

                    print logstr($block);

                    $block->{page_id} = $block->{campaign_id};

                    my $r = $app->context_on_site_rtb->partner_db_table()->edit($block, {private_auction => 0,});

                    print logstr(' block.private_auction set to 0');

                    my @default_dsps_list =
                      map {{page_id => $block->{page_id}, block_id => $block->{id}, dsp_id => $_->{id}}}
                      @{$app->context_on_site_rtb->get_default_dsps({%$block, private_auction => 0})};

                    my $dsps_deleted =
                      $app->block_dsps->partner_db_table()
                      ->delete($app->partner_db->filter({page_id => $block->{page_id}, block_id => $block->{id}}));
                    print logstr(" block dsps deleted: $dsps_deleted");

                    my $dsps_added = $app->partner_db->block_dsps->add_multi(\@default_dsps_list);
                    print logstr(" block dsps added: $dsps_added");
                }
            );
        }
    }
   );
