#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт добавляет Instream блоки с категорией 'VH: Я.Спорт' на пейджи с partner_type=yahosting

=head1 USAGE

  perl -Ilib bin/oneshots/PI-17091_add_instream_block_vh_ya_sport.pl --page_ids=12312,534142 --dry_run
  perl -Ilib bin/oneshots/PI-17091_add_instream_block_vh_ya_sport.pl --dry_run
  perl -Ilib bin/oneshots/PI-17091_add_instream_block_vh_ya_sport.pl --rollback_log=PI-17091_add_instream_block_vh_ya_sport.out
  perl -Ilib bin/oneshots/PI-17091_add_instream_block_vh_ya_sport.pl \
        --rollback=PI-17091_add_instream_block_vh_ya_sport.log \
        --exclude=123 --exclude=456 --exclude=789,10

=head1 OPTIONS

  page_ids   - Список ID площадок через запятую (необязательный)

=cut

use qbit;
use PiConstants qw($MIDROLL);
use Utils::PublicID;
use Utils::ScriptWrapper;

my $EXCLUDE_USER_ID_LIST     = [736487407];                            # fnl-license
my $SAMPLE_BLOCK_PUBLIC_ID   = 'R-V-344892-6';
my $VH_CATEGORY_ID_YASPORT   = 1024;
my $VH_CATEGORY_PATH_YASPORT = '';
my $BLOCK_CAPTION            = 'Спорт_мидролл_10сек';

sub args {
    my ($opts) = @_;

    return (
        'exclude_page_ids:s@' => \$opts->{exclude_page_ids},
        'page_ids:s'          => \$opts->{'page_ids'},
        'rollback_log:s'      => \$opts->{'rollback_log'},
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        $opts->{exclude_page_ids} = [split(/,/, join(',', @{$opts->{exclude_page_ids}}))]
          if ($opts->{exclude_page_ids} && scalar(@{$opts->{exclude_page_ids}}));

        if ($opts->{rollback_log}) {
            _rollback__archive_blocks($app, $opts);
        } else {
            _add_blocks($app, $opts);
        }
    }
   );

sub _add_blocks {
    my ($app, $opts) = @_;

    my $dry_run = $opts->{'dry_run'};

    my %page_ids;
    if (defined($opts->{'page_ids'})) {
        map {$page_ids{$_} = TRUE} split(/,/, $opts->{'page_ids'});
    }

    my $add_fields = $app->video_an_site_instream->get_add_fields();
    delete $add_fields->{$_} for (qw(adfox_user_id picategories));
    my $sample_block = $app->video_an_site_instream->get($SAMPLE_BLOCK_PUBLIC_ID, 'fields', [keys %$add_fields]);
    delete $sample_block->{page_id};

    my $filter = [
        ['owner_id',     'NOT IN', \$EXCLUDE_USER_ID_LIST],
        ['partner_type', '=',      \'yahosting'],
        {'NOT', [['multistate', '&', \8]]},     # not deleted
        {'NOT', [['multistate', '&', \32]]},    # not protected
    ];
    if (keys %page_ids) {
        push @$filter, ['id', 'IN', \[keys %page_ids]];
    }
    if (scalar @{$opts->{exclude_page_ids}}) {
        push @$filter, ['id', 'NOT IN', \$opts->{exclude_page_ids}];
    }
    my $page_list = $app->partner_db->query->select(
        alias  => 'tpage',
        table  => $app->partner_db->video_an_site,
        fields => [qw(id)],
        filter => ['AND' => $filter],
      )->left_join(
        alias   => 'tblock',
        table   => $app->partner_db()->video_an_site_instream,
        fields  => [],
        join_on => [
            'AND' => [
                [{'id' => 'tpage'} => '=' => {'page_id' => 'tblock'}],
                ['category_id', '=', \$VH_CATEGORY_ID_YASPORT],
                ['type',        '=', \$MIDROLL],
                ['caption',     '=', \$BLOCK_CAPTION],
            ]
        ],
        filter => [{id => 'tblock'} => 'is' => \undef],
      )->get_all();

    foreach my $page (@$page_list) {
        my $block2add = {
            %$sample_block,
            page_id       => $page->{id},
            category_id   => $VH_CATEGORY_ID_YASPORT,
            category_path => '',
            caption       => $BLOCK_CAPTION,
        };
        print logstr('+', {page_id => $page->{id}, block => $block2add});

        unless ($dry_run) {
            my $public_id = $app->video_an_site_instream->add(%$block2add);
            print logstr("added block: $public_id");
        }
    }
}

sub _rollback__archive_blocks {
    my ($app, $opts) = @_;

    my %exclude;
    if (my $count = scalar @{$opts->{exclude_page_ids}}) {
        @exclude{@{$opts->{exclude_page_ids}}} = (1) x $count;
    }
    if (open FH, '<', $opts->{rollback_log}) {
        my %pages;
        my @block_public_id_list =
          map {$_ =~ /added block: (\w+-\w+-\d+-\d+)/; $1;} grep {$_ =~ /added block: (\w+)/} <FH>;
        for my $block_public_id (@block_public_id_list) {
            my $page_id = (split_block_public_id($block_public_id))[1];
            if ($exclude{$page_id}) {
                print logstr("skip block: $block_public_id");
                next;
            }
            try {
                $app->video_an_site_instream->do_action($block_public_id, 'delete') unless ($opts->{dry_run});
                $pages{$page_id}++;
                print logstr("deleted block: $block_public_id");
            }
            catch {
                print logstr("!failed to delete [$block_public_id]", $_[0]->message);
            };
        }
        print logstr('Pages list: ' . join(',', sort keys %pages));
    } else {
        print logstr("!could not open rollback_log file: $!");
    }
}
