#!/usr/bin/perl
use strict;

my $db     = "mysql_partner2 --server=prod";
my $filter = q{
   domain rlike '^.*\.avito\.ru$'
or domain rlike '^.*\.avito\.dev$'
or domain rlike '^.*\.k\.avito\.ru$'
or domain rlike '^gismeteo\.ru$'
or domain rlike '^devmail\.ru$'
or domain rlike '^mail\.ru$'
or domain rlike '^ok\.ru$'
or domain rlike '^rbc\.[:alnum:]+$'
or domain rlike '^sport\.rbc\.[:alnum:]+$'
or domain rlike '^m\.rbc\.[:alnum:]+$'
or domain rlike '^sportmail\.ru$'
or domain rlike '^vk\.com$'
or domain rlike '^news\.yandex(\.[:alnum:]+)+$'
or domain rlike '^yandex(\.[:alnum:]+)+\/pogoda$'
or domain rlike '^pogoda\.yandex(\.[:alnum:]+)+$'
or domain rlike '^(tv|news)\.yandex(\.[:alnum:]+)+$'
};

my $get_blocks = "
select distinct page_id,block_id
from design_templates
where
json_extract(opts, '\$.design_settings.name') = 'adaptive'
and multistate=0
";

my $sites = [
    qq{
select page_id
from all_pages
where domain_id in (
    select id
    from site
    where ($filter)
)},
    qq{
select distinct campaign_id as page_id
from context_on_site_mirrors
where ($filter)
},
    qq{
select distinct campaign_id as page_id
from internal_context_on_site_mirrors
where ($filter)
},
    qq{
select distinct campaign_id as page_id
from internal_search_on_site_mirrors
where ($filter)
},
    qq{
select distinct campaign_id as page_id
from search_on_site_mirrors
where ($filter)
},
    qq{
select distinct campaign_id as page_id
from ssp_context_on_site_campaign_mirrors
where ($filter)
},
    qq{
select distinct campaign_id as page_id
from ssp_mobile_app_settings_mirrors
where ($filter)
},
    qq{
select distinct campaign_id as page_id
from ssp_video_an_site_mirrors
where ($filter)
},
    qq{
select distinct campaign_id as page_id
from ssp_video_an_site_mirrors
where ($filter)
}
];

my $get_pages = join "\nunion\n", map {"(\n$_\n)"} @$sites;

my $get_blocks = qq{
select d.page_id,d.block_id,count(d.id) as design_cnt
from design_templates as d
join all_blocks as b on b.id=d.block_id and b.page_id=d.page_id
where
json_extract(d.opts, '\$.design_settings.name') = 'adaptive'
and d.multistate=0
and d.page_id in (select page_id from ($get_pages) as am)
and b.multistate & 2
group by 1,2
};

$get_blocks =~ s/\s+/ /g;

my $data = `echo "$get_blocks" | $db | tail -n +2`;
print $data, "\n";
