#!/usr/bin/perl

use qbit;
use Utils::ScriptWrapper;

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе и МСФ

    Включает фичу "format_system" и конвертирует дизайны

=head1 USAGE

    perl -I./lib ./bin/oneshots/PI-17355_msf.pl
    perl -I./lib ./bin/oneshots/PI-17355_msf.pl --user_ids=161283

=head1 OPTIONS

    user_ids   - ограничить работу скрипта только указанными юзерами

=cut

my @IGNORE_USER_IDS = qw(0 54519301);

my @EXCLUDED_LOGINS = qw(
  advert-vgtrk
  afisha-partner
  appnexusssp
  avitortb2013
  e1-ru
  engageya-yaadn
  esforce-h
  fashionpress-parol
  ferraferra
  gazeta-context
  gmbox-filmpro
  gomailru-ads
  gpogosova
  grazia-pim
  herstshkulevmedia
  jmps-2
  khandozhenko-ngs
  lena235
  lenta-partner
  maximatelecom
  maximatelecomspb
  microsoft-partner
  milanor-p
  moskva24-license
  moskwa24
  m-ru-2015
  m-ru-text
  msn-p
  nb-systems
  nnov-p
  nra-vgtrk
  officengsnews
  officengsru
  partner-n1-ru
  plistarussia
  prime-tass815
  rambler-p
  rbcpartner
  riandir
  rodenproject
  rugion-rsya
  savvameteo
  savvina-ale
  secretmagru
  shmelkin-roman
  smi2smi2
  sup-partner
  tarantin555
  tarantin5555
  trista60tv
  tv360ru
  vgtrk-advert
  vk-rsya
  vk-rsya-apps
  wwwodnoklassniki-2015
  zarplata-partner
  xmarkt
  pravdaru
  rm-prj
  gsie56
  smolgazeta
  anton-kopnev
  buslaev-veles
  zelenyukigor
  kharlak
  giselena
  tachlanoff
  iev7777
  mykor-ru
  aleks-sans
  wetogether2
  valsnigir-3419
  joinfonet
  anzolkin
  wm-sochi-ru
  engine24
  demodenis
  vladtimemedia
  marlibon
  glavregtv
  avonav
  belnovosti-sait
  pozneronline
  katrus777
  kirill-skolznev
  a-strekaloff
  aoblaski
  darya-dmm
  atom-brest
  kew89
  gavinski12
  east8fish
  galand7
  gorbat22
  daragangroup
  sashken2
  vvviiitttaaa
  elizaveta-mileeva
  korobetzalena
  zhekandr
  art3562007
  semantist-svn
  denis-pokshan
  j7644
  kostikov-partner
  albatov-ev
  sportsmena
  mega-rusanov
  mozghelper
  kamfishing41
  aktualnoe-net
  f11-0-ya
  vaskevich7
  alomakin95
  miseevdmi
  rabotakondratev
  otdelkadom-surgut
  vkusnorec
  pylta-nety
  adobryi2
  zamery14
  igrotechnics
  s-sharov2009
  poembook
  maksimlenskii
  rav9261414347
  valchonok217
  odnostranichnici
  dmit-seliverstov
  dropirussia
  pestov-kk
  ip-palcev2
  levashov-e
  lastkeysi
  express-novosti
  yadzon
  antondyachenko2012
  vyacheslaw-klenin
  xuslan
  mc-julik
  olesyazubckova
  minpaint
  zhenya-filatoff-ip
  amotur
  konik-m1
  podpart
  valentyn-s2014
  domstrousam
  vdvandrej
  sir-alexey-didukh
  manykur-info
  priqru
  zrkuban
  termo-bloki
  vamsydanado-a
  merigold2012
  ztroza
  shmelevam
  fandirect
  vlbat
  nuveho
  shebukip
  arct33
  rus842
  new-times-rtb
  zerg959
  npobognik
  ice-fishing
  videouchilka
  obzorium-com
  ishakoff-maksim
  opolskiy-nikolay
  conter-1986
  gurov-wolfenshtein
  jeeps44
  brsemen
  camead
  amrompetrov
  global-stroy2014
  khrebtov66
  hazaranoc
  bigbugk
  vzdirect
  ukrdanya
  akinin-aleksey
  zifrik0206
  loveluna2015
  uspeicom
  novotex-antropov
  yur1ysamko
  cool-mirovaya
  dvd50ru
  kel-man
  afonbelgorod
  sale@portomega-ru
  r-qadi
  sarovitsch
  kapranov-tosha
  y-shishenya
  sashayam
  oneironaut
  fedor-snab
  evgeniy-chuvelev
  crazyking88
  nikolai-ebara
  mazaypsk
  yura-ponom
  shepitko-denis2018
  adsartmedia
  himorikartem
  lenamax2015
  itherm
  shuryshev-art
  pen4pals
  vaspupkinjupkin
  carence-info
  dzerzhinsk-by
  aizajcev
  tel-9168871776
  daewon-studio
  davijones1
  artur-terb
  doorman2014
  yamaratx
  mukhinhack
  vitze-did
  mishpressa
  m-881
  oldcopy
  gevko0001
  andrei-ivanovand2017
  erokart-hak-su
  lavie-ru
  sergey0971
  tihom-sergey
  grkoko
  andryandrej
  gamewelcome
  kostki
  art-barko1
  bakalov-vitaliy
  warchechnya-ru
  tedeev-mair
  jambozy
  mr-mitroxin
  maxkonchikov
  russplanet
  romefa
  nick-surganoff
  tikushin1985
  cook-it-easy
  netcellulita
  lumuratova
  mozh4zor
  yarvitto
  geliosplusru
  seosaks
  antelistratov1988
  aleksandr-dolidenok
  dubrovin3w
  movillo
  matvexa@matvexa-ru
  da-uze
  sekkray
  aukovalev
  jaroslav-harin12
  wolkv0lkov
  t12775
  kuuuzya
  amsterdance
  s0671160835
  ermackawa
  goncharov@tsyug-ru
  evg2766
  esd124
  cruglk
  www-101sp-ru
  aleksejzhiryakov
  wishmaster09
  dautova-m-n
  anturiumi
  sergei-grishai
  alex-lazareva25
  xeniyamitina
  oxi-sorokina
  olimpiev-aleksander
  china-today-ru
  ms2010m
  ipsvetlakov
  vasilymakarenkov
  maloetazhnaya-strana
  kolyushi
  dmedvedev92
  avbirka
  cryptoprofi1
  aserok01
  zinchenkodim
  gri5451
  leonikit
  my@newsite-su
  svetlanapart
  complexpr
  k01makov
  lord20109
  bvv36
  andrew-vershinin
  andrey-zarubin@anvil8-com
  shamsutdinchik2017
  artem-poluektof
  format-city18
  frimkin
  fedotov-alex-art
  angolier
  maxy-super
  karo-spb
  advert@pravda-ru
  costia-crasilnickov
  ddezov
  mserus
  avledovskoy
  vasiok4
  miropolskii
  oleg4081
  matveev-d-o
  sergiomerta
  belash-kirill2017
  webmaster@rap-area-ru
  joker0979
  exclusive-webst
  vesk42
  v-melekesov
  galaktik35
  antoniparshin
  mgladkovi4
  gkosterin
  olgaignata
  mumurik
  aleksandr1072312
  plbelkov
  essa-lab
  productplanet
  sattarov-marat
  vadik-supertrader
  musiclhub
  webvertex
  sergey-steelfox
  sshestak-ata
  algorin46
  balashov016
  ooleg-chern
  g2web
  pokatilowa-marina
  aleks-odintzowa
  vitsleiputslei
  modernwar-dima
  kenig-org
  aybobin
  zarka-rokla
  kest-20061
  varlashin-misha
  saijak22
  windowsfan-ru
  allizza435435
  rtb-offshoreview-eu
  ichi-perm
  eslibolitgolova
  aeon9999
  e-mail@poehaliputeshestvovat-ru
  andcoin-icu
  bisnesnew
  antitanki-multipack
  ya-presnova2014
  aikmaster
  pochemuu1
  super-admdc
  marinapl2000
  johncoo85
  evg-margolis
  bagira9163
  superpuma
  hotpled
  k-avksentiev
  fursanchez2016
  turysochi-com
  craftband
  5900@5900-ru
  avafin59
  comfort-fishing
  suspensiya
  vsonnov
  vasin-vig
  vmeste-dostigaem
  tapilu
  remontodelo
  yangiish
  orbie
  nevatoday2
  fastclip
  grigorievaav90
  acharya123himal
  belousov-n1k
  salamonshop
  );

sub args {
    my ($opts) = @_;

    return ('user_ids:s' => \$opts->{'user_ids'},);
}

run(
    sub {
        my ($app, $opts) = @_;

        my @user_ids = split(/,/, $opts->{'user_ids'} // '');

        my @user_ids_with_feature = map {$_->{'user_id'}} @{
            $app->partner_db->user_features->get_all(
                fields => [qw(user_id)],
                filter => ['feature', '=', \'format_system']
            )
          };

        print logstr("USERS_WITH_FEATURE:", \@user_ids_with_feature);

        push(@IGNORE_USER_IDS, _get_ignore_user_ids($app));

        my $added = $app->partner_db->user_features->add_multi(
            [
                $app->partner_db->query->select(
                    table  => $app->partner_db->users,
                    fields => {
                        user_id => 'id',
                        feature => \'format_system'
                    },
                    filter => [
                        'AND',
                        [
                            ['id', 'NOT IN', \[@user_ids_with_feature, @IGNORE_USER_IDS]],
                            [
                                'id', 'NOT IN',
                                $app->partner_db->query->select(
                                    table  => $app->partner_db->all_pages,
                                    fields => [qw(owner_id)],
                                    filter => ['model', '=', \'context_on_site_campaign']
                                )
                            ]
                        ]
                    ]
                )
            ],
            fields => [qw(feature user_id)]
        );

        print logstr("ADD_FEATURE_WITHOUT_CONVERT:", $added);

        my $filter = $app->users->get_db_filter(['id', 'NOT IN', \@IGNORE_USER_IDS]);
        $filter->and(['id', 'IN', \\@user_ids]) if @user_ids;
        $filter->and(
            [
                'id', 'NOT IN',
                $app->partner_db->query->select(
                    table  => $app->partner_db->user_features,
                    fields => [qw(user_id)],
                    filter => ['feature', '=', \'format_system']
                )
            ]
        );

        my $logins = $app->users->get_all(
            fields => [qw(id login), @{$app->users->get_depends_for_field('actions')}],
            filter => $filter
        );
        my $cntr  = 1;
        my $count = scalar @$logins;
        print logstr("Total $count logins to processing");
        foreach my $user (@$logins) {
            print logstr("PROCESSING_LOGIN:", $user->{login}, "$cntr/$count");

            try {
                $app->partner_db->transaction(
                    sub {
                        $app->user_features->add($user->{id}, 'format_system');
                    }
                );
            }
            catch {
                print STDERR logstr("ERROR:", $user, shift->message);
            };

            $cntr++;
        }
    }
   );

sub _get_ignore_user_ids {
    my ($app) = @_;

    my @user_ids =
      map {$_->{'id'}} @{$app->partner_db->users->get_all(fields => [qw(id)], filter => {login => \@EXCLUDED_LOGINS})};

    unless (@user_ids == @EXCLUDED_LOGINS) {
        print STDERR logstr('Incorrect logins in excluded list...');
        exit;
    }

    return @user_ids;
}
