#!/usr/bin/perl

use lib::abs qw(../../lib);

use qbit;
use Application;
use Utils::ScriptWrapper;

my $letter = qq{
<p>25 сентября ПИ заезжает в IDM, что это для вас значит: теперь роли пользователей будут выдаваться только через IDM,
текущие роли при этом не изменятся, но будут единожды перезапрошены спустя 30 дней после переезда.
<p>Главное, мы произведем усиление требований к авторизации, менять пароль предстоит каждые 3 месяца.
Чтобы избежать этого, вы можете сразу перейти на двухфакторную авторизацию -
<a href="https://yandex.ru/support/passport/authorization/">https://yandex.ru/support/passport/authorization/</a>.
<p>Если у вас появятся вопросы, пожалуйста, пишите на <a href="mailto:partner2-dostup\@yandex-team.ru">partner2-dostup\@yandex-team.ru</a>.
<p>Всем продуктивной рабочей недели!
};

sub main {
    my ($app, $opts) = @_;

    $app->set_cur_user({id => 0});
    my $tmp_rights = $app->add_all_tmp_rights();

    my @int_role = map {$_->{id}} grep {$_->{idm}} @{$app->rbac->get_roles};
    my $query = $app->partner_db->query->select(
        table  => $app->partner_db->user_role,
        filter => [role_id => 'IN' => \\@int_role],
        fields => [],
      )->join(
        table   => $app->partner_db->users,
        fields  => [qw(login email)],
        join_on => [id => '=' => {user_id => $app->partner_db->user_role}],
      )->distinct;

    my $list = $query->get_all;

    my @list;
    my %idx;
    for my $row (@$list) {
        unless ($row->{email}) {
            warn logstr("NO_EMAIL for '$row->{login}'");
            next;
        }

        next if $idx{$row->{email}};
        $idx{$row->{email}} = 1;

        push @list, [split /\s*,\s*/, $row->{email}];
    }

    print logstr("START sending " . scalar(@list));

    for my $email (@list) {
        send_letter($app, $email);
    }
}

sub send_letter {
    my ($app, $email) = @_;

    my $email_str = ref $email ? join(', ', @$email) : $email;

    try {
        $app->mailer->send(
            'body' => {
                'content_type' => 'text/html',
                'template'     => 'mail_notification/base.html.tt2',
                'type'         => 'TT2',
                'vars'         => {'message_body' => $letter,}
            },
            'content_type' => 'text/html',
            'from'         => 'default',
            'subject'      => 'ВНИМАНИЕ! 25 сентября ПИ заезжает в IDM',
            'to'           => $email
        );
        print logstr("Send to '$email_str' success");
    }
    catch {
        my ($e) = @_;
        warn logstr("FAIL send to '$email_str': " . $e->message);
    };
}

run(\&main);

__END__

SELECT
    `users`.`email` AS `email`
FROM `user_role`
INNER JOIN `users` ON (
    `users`.`id` = `user_role`.`user_id`
)
WHERE (
    `user_role`.`role_id` IN ('2', '3', '4', '8', '15', '17', '19')
)
