#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт исправляет слетевшую кодировку псоле миграции в PI_17469

=head1 USAGE

  perl bin/oneshots/PI-17786_fix_utf8_after_migration.pl \
     --commit \
     --rollback=PI-17469_move_old_natural_blocks_from_content_to_new_natural.out

=head1 OPTIONS

  rollback - имя лог-файла из PI_17469
  commit   - делать изменения в базе

=cut

use lib::abs qw(../../lib);
use qbit;

use Utils::PublicID 'split_block_public_id';
use Utils::ScriptWrapper;

my %MODEL_MAP = (
    'N-A-' => 'context_on_site_natural',
    'N-I-' => 'internal_context_on_site_natural',
);

sub args {
    my ($opts) = @_;

    return ('rollback=s' => \$opts->{rollback});
}

sub main {
    my ($app, $opts) = @_;

    my $fh;
    if (open($fh, '<', $opts->{rollback})) {
        while (my $str = <$fh>) {
            if ($str =~ /Add block:\s+(\S+)\s+(.+)$/) {
                my $public_id = $1;
                my $block     = from_json($2);

                next if $block->{is_custom_bk_data};

                my ($model_short, $page_id, $block_id) = split_block_public_id($public_id);
                my $model    = $MODEL_MAP{$model_short};
                my $pk       = $app->partner_db->$model->primary_key();
                my $block_pk = {
                    $pk->[0] => $page_id,
                    $pk->[1] => $block_id,
                };

                print logstr("MAKE", $public_id);
                make_block($app, $model, $public_id, $block_pk, $opts->{commit});
            }
        }
        close $fh;
    } else {
        print logstr 'Can\'t open log-file for rollback: ', $!;
        return;
    }

}

sub make_block {
    my ($app, $model, $public_id, $block_pk, $commit) = @_;
    try {
        my $orig = $app->$model->get($public_id, fields => ['opts']);
        my $opts = to_json($orig->{opts});
        utf8::decode($opts);

        print logstr("READ", $public_id, to_json($orig->{opts}));
        if ($commit) {
            $app->$model->partner_db_table->edit($block_pk, {opts => $opts});
            $app->$model->do_action($public_id, 'set_need_update');
            print logstr("WRITE", $public_id, $opts);
        }
    }
    catch {
        my ($e) = @_;
        print logstr("FAIL", $public_id, ref($e), $e->message);
    };
}

run(\&main);
