#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_META_CLUSTER='pythia'
YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner/dict'
YT_TABLE_PATH="${YT_PROJECT_PATH}/target_tags"

TAG_VALUE='indoor-testing-page'
TAG_ID='6'
DATA="{\"id\":$TAG_ID,\"name\":\"$TAG_VALUE\",\"descr\":\"$TAG_VALUE\"}"

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='arnold'

else
    echo "~using TEST config";
fi

echo "$DATA" | yt insert-rows $YT_TABLE_PATH  --no-require-sync-replica  --format json  --proxy $YT_META_CLUSTER
yt select "* from [$YT_TABLE_PATH] limit 10" --format json --proxy $YT_META_CLUSTER

exit 0;
