#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе

    Добавляет на блоки с десктопной версией дизайны по условию из тикета PI-16600

=head1 USAGE

    perl -I./lib ./bin/oneshots/PI-18012_add_designs_for_blocks_in_godmode.pl
    perl -I./lib ./bin/oneshots/PI-18012_add_designs_for_blocks_in_godmode.pl --rollback=file.log

=head1 OPTIONS

    rollback - передать лог-файл предыдущего выполнения скрипта для отката

=cut

use qbit;

use Utils::ScriptWrapper;

my $DESIGN_CAPTION = {
    '300x600'          => '300x600',
    'adaptive0418'     => 'Адаптивный',
    'posterVertical'   => 'Постер',
    'posterHorizontal' => 'Постер',
};

my $DESIGNS = {
    '300x600' => {
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'block',
        'favicon'         => JSON::XS::true,
        'horizontalAlign' => JSON::XS::true,
        'hoverColor'      => 'DD0000',
        'imagesFirst'     => JSON::XS::false,
        'linksUnderline'  => JSON::XS::true,
        'name'            => '300x600',
        'noSitelinks'     => JSON::XS::false,
        'siteBgColor'     => 'FFFFFF',
        'sitelinksColor'  => '0000CC',
        'textColor'       => '000000',
        'titleColor'      => '0000CC',
        'urlColor'        => '006600'
    },
    'posterVertical' => {
        'borderColor'     => 'DDDCDA',
        'favicon'         => JSON::XS::true,
        'horizontalAlign' => JSON::XS::true,
        'hoverColor'      => 'DD0000',
        'linksUnderline'  => JSON::XS::true,
        'name'            => 'posterVertical',
        'noSitelinks'     => JSON::XS::false,
        'siteBgColor'     => 'FFFFFF',
        'sitelinksColor'  => '0000CC',
        'textColor'       => '000000',
        'titleColor'      => '0000CC',
        'titleFontSize'   => '3',
        'urlColor'        => '006600'
    },
    'posterHorizontal' => {
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'favicon'         => JSON::XS::true,
        'horizontalAlign' => JSON::XS::true,
        'hoverColor'      => 'DD0000',
        'imagesFirst'     => JSON::XS::false,
        'limit'           => '4',
        'linksUnderline'  => JSON::XS::true,
        'name'            => 'posterHorizontal',
        'noSitelinks'     => JSON::XS::false,
        'siteBgColor'     => 'FFFFFF',
        'sitelinksColor'  => '0000CC',
        'textColor'       => '000000',
        'titleColor'      => '0000CC',
        'titleFontSize'   => '3',
        'urlColor'        => '006600'
    },
    '28bc00 with border' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => '28BC00',
        'borderColor'        => 'DDDCDA',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    '315efb' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => '315EFB',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },

    '315efb with border' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => '315EFB',
        'borderColor'        => 'DDDCDA',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    'f6f8f9' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => 'F6F8F9',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    'f6f8f9 with border' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => 'F6F8F9',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    'fc2772' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => 'FC2772',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    'fc2772 with border' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => 'FC2772',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    '315efb transparent' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'urlColor'        => '315EFB',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'hoverColor'      => '315EFB',
        'skin'            => 'tower-avito leaderboard-avito row'
    },
    '315efb transparent with border' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'urlColor'        => '315EFB',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'hoverColor'      => '315EFB',
        'skin'            => 'tower-avito leaderboard-avito row'
    },
    'fc2772 transparent' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'urlColor'        => 'FC2772',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'hoverColor'      => '315EFB',
        'skin'            => 'tower-avito leaderboard-avito row'
    },
    'fc2772 transparent with border' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'urlColor'        => 'FC2772',
        'borderColor'     => 'DDDCDA',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'hoverColor'      => '315EFB',
        'skin'            => 'tower-avito leaderboard-avito row'
    },
    'fdb712 with border DDDCDA' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => 'FDB712',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'DDDCDA',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    'fdb712 with border ebebff' => {
        'horizontalAlign'    => JSON::XS::true,
        'name'               => 'adaptive0418',
        'titleColor'         => '000000',
        'textColor'          => '000000',
        'urlBackgroundColor' => 'FDB712',
        'bgColor'            => 'FFFFFF',
        'borderColor'        => 'EBEBFF',
        'borderRadius'       => JSON::XS::false,
        'borderType'         => 'ad',
        'favicon'            => JSON::XS::true,
        'hoverColor'         => '315EFB',
        'skin'               => 'tower-avito leaderboard-avito row'
    },
    'fdb712 transparent with border DDDCDA' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'urlColor'        => 'FDB712',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'hoverColor'      => '315EFB',
        'skin'            => 'tower-avito leaderboard-avito row'
    },
    'fdb712 transparent with border ebebff' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'urlColor'        => 'FDB712',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'EBEBFF',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'hoverColor'      => '315EFB',
        'skin'            => 'tower-avito leaderboard-avito row'
    }
};

my $SETTINGS = [
    {
        page_id     => 70470,
        blocks      => [26, 27, 7, 8],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs     => [
            '315efb with border',
            '28bc00 with border',
            'f6f8f9 with border',
            '315efb transparent with border',
            'posterVertical',
            '300x600'
        ]
    },
    {
        page_id     => 70470,
        blocks      => [9, 28, 5, 24, 30, 11],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs     => [
            '315efb with border',
            '28bc00 with border',
            'f6f8f9 with border',
            '315efb transparent with border',
            'posterHorizontal'
        ],
    },
    {
        page_id     => 70470,
        blocks      => [33, 14],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs     => [
            '315efb with border',
            '28bc00 with border',
            'f6f8f9 with border',
            '315efb transparent with border',
            'posterHorizontal'
        ],
    },
    {
        page_id     => 70472,
        blocks      => [32, 59, 33, 60, 19, 46, 20, 47],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical'],
    },
    {
        page_id     => 70472,
        blocks      => [21, 23, 34, 36, 38, 48, 50, 62, 64, 66, 26, 52],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal'],
    },
    {
        page_id     => 70472,
        blocks      => [22, 24, 35, 37, 39, 49, 51, 63, 65, 67],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal'],
    },
    {
        page_id     => 228750,
        blocks      => [2, 3, 15, 16, 42, 43, 59, 60],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs =>
          ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical', '300x600'],
    },
    {
        page_id     => 228750,
        blocks      => [5, 8, 18, 21, 45, 48, 62, 65],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal'],
    },
    {
        page_id     => 228750,
        blocks      => [6, 9, 19, 22, 30, 31, 32, 33, 46, 49, 53, 54, 63, 66, 68, 69],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal'],
    },
    {
        page_id     => 249322,
        blocks      => [3, 4, 14, 15, 29, 30, 39, 40],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs =>
          ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical', '300x600']
    },
    {
        page_id     => 249322,
        blocks      => [5, 7, 17, 19, 21, 31, 33, 42, 44, 46, 10, 35],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 249322,
        blocks      => [6, 8, 18, 20, 22, 32, 34, 43, 45, 47],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 231634,
        blocks      => [1, 2, 13, 14, 32, 33, 48, 49],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 231634,
        blocks      => [3, 6, 9, 15, 18, 21, 34, 37, 40, 50, 53, 56],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 231634,
        blocks      => [4, 5, 7, 8, 16, 17, 19, 20, 35, 36, 38, 39, 51, 52, 55,],    # 64],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 247702,
        blocks      => [3, 4, 13, 14, 38, 39, 54, 55],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 247702,
        blocks      => [5, 7, 10, 15, 17, 20, 41, 43, 45, 56, 58,],    # 6],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 247702,
        blocks      => [6, 8, 16, 18, 42, 44, 57, 59],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 141078,
        blocks      => [14, 15, 36, 37, 54, 55, 65, 66],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 141078,
        blocks      => [16, 18, 39, 41, 57, 59, 67, 69],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 141078,
        blocks      => [17, 19, 40, 42, 58, 60, 68, 70],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 141078,
        blocks      => [21, 44, 61, 72],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 1,
        designs     => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 222078,
        blocks      => [7, 15, 20, 21, 41, 42, 43, 44],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 222078,
        blocks      => [3, 4, 17, 22, 23, 30, 45, 46, 47, 48, 49, 50],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 222078,
        blocks      => [9, 28, 60, 61],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 1,
        designs     => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 247699,
        blocks      => [3, 4, 15, 16, 36, 37, 47, 48],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['fc2772 with border', 'f6f8f9 with border', 'fc2772 transparent with border', 'posterVertical']
    },
    {
        page_id     => 247699,
        blocks      => [5, 7, 11, 17, 20, 27, 38, 40, 43, 49, 52, 57],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['fc2772', 'f6f8f9', 'fc2772 transparent', 'posterHorizontal']
    },
    {
        page_id     => 247699,
        blocks      => [6, 8, 18, 21, 39, 41, 50, 53],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['fc2772', 'f6f8f9', 'fc2772 transparent', 'posterHorizontal']
    },
    {
        page_id     => 247699,
        blocks      => [19, 22, 51, 54],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 2,
        designs     => ['fc2772', 'f6f8f9', 'fc2772 transparent', 'posterHorizontal']
    },
    {
        page_id     => 140555,
        blocks      => [6, 9, 10, 13, 16, 17, 21, 22, 25, 26, 29, 30, 50, 51],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 140555,
        blocks      => [8, 11, 15, 18, 37, 41],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 140543,
        blocks      => [6, 7, 18, 19, 34, 35, 45, 46],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 140543,
        blocks      => [8, 10, 21, 23, 36, 38, 48, 50, 13, 25, 40, 52],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 140543,
        blocks      => [9, 11, 22, 24, 37, 39, 49, 51, 27, 53],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 70467,
        blocks      => [26, 27, 29, 34, 44, 49],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 70467,
        blocks      => [28, 35, 50, 62, 63, 79],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 70467,
        blocks      => [30, 36, 51, 58, 59, 60, 61, 76, 77],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id => 250894,
        blocks  => [
            71, 96,  73,  74,  75,  76,  98,  100, 102, 104, 82,  97,  83,  84, 85, 86,
            99, 101, 103, 105, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133
        ],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs     => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 250894,
        blocks      => [22, 118, 68, 106, 34, 116, 93, 119, 87, 107, 92, 117, 134, 135, 136, 137, 138, 139],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 70463,
        blocks      => [17, 18, 24, 25],
        form_factor => 'vertical',
        height      => 600,
        limit       => 3,
        designs     => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 70463,
        blocks      => [19, 20, 27, 28],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs     => ['315efb', 'f6f8f9', '315efb transparent', 'posterHorizontal']
    },
    {
        page_id     => 70466,
        blocks      => [13, 16],
        form_factor => 'vertical',
        height      => 600,
        limit       => 1,
        designs     => ['315efb with border', 'f6f8f9 with border', '315efb transparent with border', 'posterVertical']
    },
    {
        page_id     => 186527,
        blocks      => [43, 44, 45, 46, 12, 24, 13, 25],
        form_factor => 'vertical',
        height      => 600,
        limit       => 2,
        designs     => [
            'fdb712 with border DDDCDA',
            'fdb712 with border ebebff',
            'fdb712 transparent with border DDDCDA',
            'fdb712 transparent with border ebebff',
            'posterVertical'
        ]
    },
    {
        page_id     => 186527,
        blocks      => [49, 50, 51, 52, 53, 54, 71, 69, 15, 27, 17, 29, 18, 30, 70, 68],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 3,
        designs     => [
            'fdb712 with border DDDCDA',
            'fdb712 with border ebebff',
            'fdb712 transparent with border DDDCDA',
            'fdb712 transparent with border ebebff',
            'posterHorizontal'
        ]
    },
    {
        page_id     => 186527,
        blocks      => [55, 56, 16, 28],
        form_factor => 'horizontal',
        height      => 300,
        limit       => 4,
        designs     => [
            'fdb712 with border DDDCDA',
            'fdb712 with border ebebff',
            'fdb712 transparent with border DDDCDA',
            'fdb712 transparent with border ebebff',
            'posterHorizontal'
        ]
    }
];

sub convert_design {
    my ($design) = @_;

    my $new_design = clone $design;

    $new_design->{titleFontSize}      //= 1;
    $new_design->{urlBackgroundColor} //= 'FFFFFF';
    $new_design->{sitelinksColor}     //= '000000';
    $new_design->{siteBgColor}        //= 'FFFFFF';
    $new_design->{hoverColor}         //= '000000';
    $new_design->{urlColor}           //= '000000';
    $new_design->{noSitelinks}        //= JSON::XS::false;
    $new_design->{imagesFirst}        //= JSON::XS::false;
    $new_design->{linksUnderline}     //= JSON::XS::false;
    $new_design->{favicon}            //= JSON::XS::false;
    $new_design->{fontSize}           //= 1;
    $new_design->{fontFamily}         //= 'arial';
    $new_design->{borderType}         //= 'ad' if (exists $new_design->{borderColor});
    $new_design->{borderRadius}       //= JSON::XS::false if (exists $new_design->{borderColor});
    $new_design->{adaptiveHeight} = delete $new_design->{height} if (exists $new_design->{height});
    delete $new_design->{skin};
    return $new_design;
}

sub args {
    my ($opts) = @_;

    return ('rollback_file:s' => \$opts->{rollback_file},);
}

run(
    sub {
        my ($app, $opts) = @_;

        my $log = $opts->{'rollback_file'};

        if (defined $log) {

            open(my $fh, '<', $log) or die $!;

            while (my $line = <$fh>) {
                chomp($line);

                if ($line =~ /New design ID:\s+(\d+)/) {
                    my $design_id = $1;
                    $app->design_templates->do_action($design_id, 'delete');
                    print logstr "Delete design", $design_id;
                }
                if ($line =~ /Old bk_data for block\s+(R-A-\d+-\d+)\s+(.*)$/) {
                    my $public_id = $1;
                    my $bk_data   = from_json($2);

                    $app->context_on_site_rtb->do_action($public_id, 'edit', 'bk_data', $bk_data);
                    print logstr "Update block", $public_id;
                }
            }

        } else {
            my @skipped_blocks;
            foreach my $settings (@$SETTINGS) {
                foreach my $block_id (@{$settings->{blocks}}) {
                    my $block_data = $app->context_on_site_rtb->get(
                        {campaign_id => $settings->{page_id}, id => $block_id},
                        fields => [qw(public_id bk_data design_templates is_custom_bk_data)]
                    );
                    unless ($block_data->{is_custom_bk_data}) {
                        push @skipped_blocks, $block_data->{public_id};
                        next;
                    }
                    print logstr "Old bk_data for block ", $block_data->{public_id}, to_json($block_data->{bk_data});
                    my $bk_data    = from_json($block_data->{bk_data});
                    my $rtb_design = $bk_data->{RtbDesign};
                    # Преобразуем поле RtbDesign, если это необходимо
                    if (ref $rtb_design eq 'HASH') {
                        print logstr 'HASH';
                    } else {
                        print logstr 'JSON';
                        my $design = from_json("{$rtb_design}");
                        $design->{blockId} = $block_data->{public_id};
                        $rtb_design = {
                            @{$block_data->{design_templates}}[0]->{id} => {
                                'name'   => 'default design template',
                                'design' => $design,
                            }
                        };
                    }

                    my $cntr = 1;
                    foreach my $design_name (@{$settings->{designs}}) {
                        my $design_settings = $DESIGNS->{$design_name};
                        $design_settings->{limit} = $settings->{limit};
                        $design_settings->{height} = $settings->{height} if $design_settings->{name} eq 'adaptive0418';
                        my $new_design = {
                            'block_id'                => $block_id,
                            'caption'                 => $cntr++ . ". " . $DESIGN_CAPTION->{$design_settings->{name}},
                            'design_settings'         => convert_design($design_settings),
                            'filter_tags'             => undef,
                            'form_factor'             => $settings->{form_factor},
                            'is_custom_format_direct' => 1,
                            'order_num'               => 0,
                            'page_id'                 => $settings->{page_id}
                        };
                        my $new_id = $app->design_templates->add(%$new_design);
                        print logstr "New design ID:", $new_id;
                        $rtb_design->{$new_id} = {
                            name   => $new_design->{caption},
                            design => {%$design_settings, blockId => $block_data->{public_id}},
                        };
                    }
                    $bk_data->{RtbDesign} = $rtb_design;
                    $app->context_on_site_rtb->do_action($block_data->{public_id},
                        'edit', 'bk_data', to_json($bk_data, pretty => TRUE));
                }
            }
            print logstr "Skipped blocks not in godmode:", @skipped_blocks if @skipped_blocks;
        }
    }
   )
