#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе

    Добавляет на блоки с десктопной версией дизайны по условию из тикета PI-16600

=head1 USAGE

    perl -I./lib ./bin/oneshots/PI-18228_add_designs_for_blocks_in_godmode.pl
    perl -I./lib ./bin/oneshots/PI-18228_add_designs_for_blocks_in_godmode.pl --rollback=file.log

=head1 OPTIONS

    rollback - передать лог-файл предыдущего выполнения скрипта для отката

=cut

use qbit;

use Utils::ScriptWrapper;

my $DESIGN_CAPTION = {
    'adaptive0418'      => 'Адаптивный',
    'oldPosterVertical' => 'Постер',
    'posterVertical'    => 'Постер',
    'posterHorizontal'  => 'Постер',
};

my $DESIGN_TEMPLATES = {
    'adaptive0418 border' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'skin'            => 'tower-avito leaderboard-avito row'
    },
    'adaptive0418 border FFFFFF' => {
        'horizontalAlign' => JSON::XS::true,
        'name'            => 'adaptive0418',
        'titleColor'      => '000000',
        'textColor'       => '000000',
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'skin'            => 'tower-avito leaderboard-avito row'
    },
    'adaptive amp' => {
        'bgColor'         => 'FFFFFF',
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::true,
        'borderType'      => 'ad',
        'horizontalAlign' => JSON::XS::false,
        'hoverColor'      => '',
        'advSpacing'      => 6,
        'imageWidth'      => '130',
        'limit'           => 2,
        'name'            => 'adaptive0418',
        'textColor'       => '000000',
        'titleColor'      => '000000',
        'warningCompact'  => 1,
        'width'           => 300,
        'height'          => 250,
        'urlColor'        => '000000',
    },
};
my $DESIGNS = {
    '0050ff amp' => {template => 'adaptive amp', hoverColor => '0050FF'},
    '00A3D9 amp' => {template => 'adaptive amp', hoverColor => '00A3D9'},
    '24af30 amp' => {template => 'adaptive amp', hoverColor => '24AF30'},
    '315efb amp' => {template => 'adaptive amp', hoverColor => '315EFB'},
    '3282d2 amp' => {template => 'adaptive amp', hoverColor => '3282D2'},
    'CC3333 amp' => {template => 'adaptive amp', hoverColor => 'CC3333'},
    'ebebff amp' => {template => 'adaptive amp', hoverColor => 'EBEBFF'},
    'ed4e2e amp' => {template => 'adaptive amp', hoverColor => 'ED4E2E'},
    'ed9081 amp' => {template => 'adaptive amp', hoverColor => 'ED9081'},
    'f7d985 amp' => {template => 'adaptive amp', hoverColor => 'F7D985'},
    'F7F7F7 amp' => {template => 'adaptive amp', hoverColor => 'F7F7F7'},
    'fc2772 amp' => {template => 'adaptive amp', hoverColor => 'FC2772'},
    'fcc11b amp' => {template => 'adaptive amp', hoverColor => 'FCC11B'},
    'ff0066 amp' => {template => 'adaptive amp', hoverColor => 'FF0066'},
    'ffea00 amp' => {template => 'adaptive amp', hoverColor => 'FFEA00'},
    'ff7d63 amp' => {template => 'adaptive amp', hoverColor => 'FF7D63'},

    'ed4e2e border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'ED4E2E',
        'hoverColor'         => 'ED4E2E',
    },
    'ed4e2e border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => 'ED4E2E',
        'hoverColor' => 'ED4E2E',
    },
    '9b9b9b border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '9B9B9B',
        'hoverColor'         => 'ED4E2E',
    },
    '315efb border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '315EFB',
        'hoverColor'         => '315EFB',
    },
    '315efb border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => '315EFB',
        'hoverColor' => '315EFB',
    },
    '9b9b9b border2' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '9B9B9B',
        'hoverColor'         => '315EFB',
    },
    'ffea00 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'FFEA00',
        'hoverColor'         => 'FFEA00',
    },
    'ffea00 border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => 'FFEA00',
        'hoverColor' => 'FFEA00',
    },
    '989898 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '989898',
        'hoverColor'         => 'FFEA00',
    },
    'fcc11b border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'FCC11B',
        'hoverColor'         => 'FCC11B',
    },
    'fcc11b border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => 'FCC11B',
        'hoverColor' => 'FCC11B',
    },
    '989898 border2' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '989898',
        'hoverColor'         => 'FCC11B',
    },
    'f7d985 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'F7D985',
        'hoverColor'         => 'F7D985',
    },
    'f7d985 border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => 'F7D985',
        'hoverColor' => 'F7D985',
    },
    '989898 border3' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '989898',
        'hoverColor'         => 'F7D985',
    },
    'ff7d63 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'FF7D63',
        'hoverColor'         => 'FF7D63',
    },
    'ff7d63 border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => 'FF7D63',
        'hoverColor' => 'FF7D63',
    },
    '78D9EA border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '78D9EA',
        'hoverColor'         => 'FF7D63',
    },
    'ff7d63 FFFFFF border' => {
        'template'           => 'adaptive0418 border FFFFFF',
        'urlBackgroundColor' => 'FF7D63',
        'hoverColor'         => 'FF7D63',
    },
    'ff7d63 FFFFFF border transparent' => {
        'template'   => 'adaptive0418 border FFFFFF',
        'urlColor'   => 'FF7D63',
        'hoverColor' => 'FF7D63',
    },
    '78D9EA FFFFFF border' => {
        'template'           => 'adaptive0418 border FFFFFF',
        'urlBackgroundColor' => '78D9EA',
        'hoverColor'         => 'FF7D63',
    },
    'ed9081 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'ED9081',
        'hoverColor'         => 'ED9081',
    },
    'ed9081 border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => 'ED9081',
        'hoverColor' => 'ED9081',
    },
    '989898 border4' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '989898',
        'hoverColor'         => 'ED9081',
    },
    'ff0066 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'FF0066',
        'hoverColor'         => 'FF0066',
    },
    'ff0066 border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => 'FF0066',
        'hoverColor' => 'FF0066',
    },
    'dfc991 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => 'DFC991',
        'hoverColor'         => 'FF0066',
    },
    '00A3D9 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '00A3D9',
        'hoverColor'         => '00A3D9',
    },
    '00A3D9 border transparent' => {
        'template'   => 'adaptive0418 border',
        'urlColor'   => '00A3D9',
        'hoverColor' => '00A3D9',
    },
    '989898 border5' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '989898',
        'hoverColor'         => '00A3D9',
    },
    '004359 border' => {
        'template'           => 'adaptive0418 border',
        'urlBackgroundColor' => '004359',
        'hoverColor'         => '004359',
    },

    'oldPosterVertical' => {
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'borderType'      => 'ad',
        'favicon'         => JSON::XS::true,
        'fontSize'        => 1,
        'horizontalAlign' => JSON::XS::false,
        'hoverColor'      => 'DD0000',
        'imagesFirst'     => JSON::XS::false,
        'limit'           => 2,
        'linksUnderline'  => JSON::XS::true,
        'name'            => 'oldPosterVertical',
        'noSitelinks'     => JSON::XS::false,
        'siteBgColor'     => 'FFFFFF',
        'sitelinksColor'  => '0000CC',
        'textColor'       => '000000',
        'titleColor'      => '0000CC',
        'titleFontSize'   => 3,
        'urlColor'        => '006600'
    },
    'posterVertical' => {
        'borderColor'     => 'DDDCDA',
        'favicon'         => JSON::XS::true,
        'horizontalAlign' => JSON::XS::true,
        'hoverColor'      => 'DD0000',
        'linksUnderline'  => JSON::XS::true,
        'name'            => 'posterVertical',
        'noSitelinks'     => JSON::XS::false,
        'siteBgColor'     => 'FFFFFF',
        'sitelinksColor'  => '0000CC',
        'textColor'       => '000000',
        'titleColor'      => '0000CC',
        'titleFontSize'   => '3',
        'urlColor'        => '006600'
    },
    'posterHorizontal' => {
        'borderColor'     => 'DDDCDA',
        'borderRadius'    => JSON::XS::false,
        'favicon'         => JSON::XS::true,
        'horizontalAlign' => JSON::XS::true,
        'hoverColor'      => 'DD0000',
        'imagesFirst'     => JSON::XS::false,
        'limit'           => '4',
        'linksUnderline'  => JSON::XS::true,
        'name'            => 'posterHorizontal',
        'noSitelinks'     => JSON::XS::false,
        'siteBgColor'     => 'FFFFFF',
        'sitelinksColor'  => '0000CC',
        'textColor'       => '000000',
        'titleColor'      => '0000CC',
        'titleFontSize'   => '3',
        'urlColor'        => '006600'
    },
};

my $SETTINGS = [
    {
        page_id     => 155221,
        blocks      => [7, 8, 20, 21, 38, 39, 40, 41],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['ed4e2e border', '9b9b9b border', 'ed4e2e border transparent', 'posterVertical']
    },
    {
        page_id     => 155221,
        blocks      => [11, 16, 24, 29, 46, 47, 54, 55],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 2,
        designs => ['ed4e2e border', '9b9b9b border', 'ed4e2e border transparent', 'posterHorizontal']
    },
    {
        page_id     => 155221,
        blocks      => [10, 12, 15, 23, 25, 28, 44, 45, 48, 49, 52, 53],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['ed4e2e border', '9b9b9b border', 'ed4e2e border transparent', 'posterHorizontal']
    },
    {
        page_id     => 155221,
        blocks      => [13, 26, 50, 51],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs     => ['ed4e2e border', '9b9b9b border', 'ed4e2e border transparent', 'posterHorizontal']
    },
    {
        page_id     => 141107,
        blocks      => [13, 14, 21, 22, 38, 39, 45, 46],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['315efb border', '9b9b9b border2', '315efb border transparent', 'posterVertical']
    },
    {
        page_id     => 141107,
        blocks      => [15, 40, 23, 47],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs     => ['315efb border', '9b9b9b border2', '315efb border transparent', 'posterHorizontal']
    },
    {
        page_id     => 141107,
        blocks      => [19, 43, 27, 51, 18, 42, 26, 50, 57, 72, 69, 73, 58, 74, 59, 75],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['315efb border', '9b9b9b border2', '315efb border transparent', 'posterHorizontal']
    },
    {
        page_id     => 348665,
        blocks      => [2, 10, 32, 33, 3, 11, 34, 35],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['ffea00 border', '989898 border', 'ffea00 border transparent', 'posterVertical']
    },
    {
        page_id     => 348665,
        blocks      => [5, 36, 13, 37, 7, 40, 15, 41, 21, 42, 22, 43],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs => ['ffea00 border', '989898 border', 'ffea00 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 348665,
        blocks      => [8, 50, 16, 51, 6, 38, 14, 39],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['ffea00 border', '989898 border', 'ffea00 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 348662,
        blocks      => [3, 8, 36, 37, 4, 9, 38, 39, 56],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['ffea00 border', '989898 border', 'ffea00 border transparent', 'posterVertical']
    },
    {
        page_id     => 348662,
        blocks      => [5, 10, 42, 43],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs     => ['ffea00 border', '989898 border', 'ffea00 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 348662,
        blocks      => [16, 17, 50, 51, 6, 11, 46, 47],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['ffea00 border', '989898 border', 'ffea00 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 167747,
        blocks      => [3, 10, 23, 24, 4, 11, 25, 26],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['fcc11b border', '989898 border2', 'fcc11b border transparent', 'posterVertical']
    },
    {
        page_id     => 167747,
        blocks      => [5, 7, 12, 14, 29, 30, 31, 32],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs => ['fcc11b border', '989898 border2', 'fcc11b border transparent', 'posterHorizontal']
    },
    {
        page_id     => 167747,
        blocks      => [16, 33, 38, 39],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs     => ['fcc11b border', '989898 border2', 'fcc11b border transparent', 'posterHorizontal']
    },
    {
        page_id     => 343937,
        blocks      => [1, 2, 9, 10, 18, 19, 26, 27],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['f7d985 border', '989898 border3', 'f7d985 border transparent', 'posterVertical']
    },
    {
        page_id     => 343937,
        blocks      => [4, 12, 21, 29, 36, 37, 39, 40],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs => ['f7d985 border', '989898 border3', 'f7d985 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 343937,
        blocks      => [5, 13, 22, 30],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs     => ['f7d985 border', '989898 border3', 'f7d985 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 184273,
        blocks      => [21, 23, 40, 42],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs =>
          ['ff7d63 FFFFFF border', '78D9EA FFFFFF border', 'ff7d63 FFFFFF border transparent', 'posterVertical']
    },
    {
        page_id     => 184273,
        blocks      => [5, 46, 8, 51],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs =>
          ['ff7d63 FFFFFF border', '78D9EA FFFFFF border', 'ff7d63 FFFFFF border transparent', 'posterHorizontal']
    },
    {
        page_id     => 184273,
        blocks      => [3, 4, 39, 41],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs     => ['ff7d63 border', '78D9EA border', 'ff7d63 border transparent', 'posterVertical']
    },
    {
        page_id     => 184273,
        blocks      => [6, 7, 10, 11, 47, 48, 49, 50],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['ff7d63 border', '78D9EA border', 'ff7d63 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 163132,
        blocks      => [10, 23, 24, 49, 53, 54, 55, 56],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['ed9081 border', '989898 border4', 'ed9081 border transparent', 'posterVertical']
    },
    {
        page_id     => 163132,
        blocks      => [13, 29, 61, 62],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 2,
        designs     => ['ed9081 border', '989898 border4', 'ed9081 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 163132,
        blocks      => [11, 25, 57, 58, 45, 65],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs => ['ed9081 border', '989898 border4', 'ed9081 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 163132,
        blocks      => [14, 16, 28, 39, 63, 64, 72, 73],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['ed9081 border', '989898 border4', 'ed9081 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 163133,
        blocks      => [9, 24, 25, 26, 49, 50, 51, 52],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['ff0066 border', 'dfc991 border', 'ff0066 border transparent', 'posterVertical']
    },
    {
        page_id     => 163133,
        blocks      => [12, 13, 28, 29, 54, 55, 62, 65],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs => ['ff0066 border', 'dfc991 border', 'ff0066 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 163133,
        blocks      => [14, 30, 38, 39, 41, 44, 56, 57, 58, 59, 63, 64],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['ff0066 border', 'dfc991 border', 'ff0066 border transparent', 'posterHorizontal']
    },
    {
        page_id     => 348677,
        blocks      => [37, 38, 48, 49, 66, 67, 68, 69,],
        form_factor => 'vertical',
        height      => "600",
        limit       => 2,
        designs => ['00A3D9 border', '989898 border5', '00A3D9 border transparent', '004359 border', 'posterVertical']
    },
    {
        page_id     => 348677,
        blocks      => [40, 52, 76, 77],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 3,
        designs => ['00A3D9 border', '989898 border5', '00A3D9 border transparent', '004359 border', 'posterHorizontal']
    },
    {
        page_id     => 348677,
        blocks      => [43, 46, 53, 54, 72, 73, 74, 75],
        form_factor => 'horizontal',
        height      => "300",
        limit       => 4,
        designs => ['00A3D9 border', '989898 border5', '00A3D9 border transparent', '004359 border', 'posterHorizontal']
    },
    {
        page_id     => 444569,
        blocks      => [1, 2, 3, 4],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '00A3D9 amp']
    },
    {
        page_id     => 429685,
        blocks      => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'ff7d63 amp']
    },
    {
        page_id     => 424437,
        blocks      => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'ed4e2e amp']
    },
    {
        page_id     => 400656,
        blocks      => [26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '3282d2 amp']
    },
    {
        page_id     => 369038,
        blocks      => [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'ffea00 amp']
    },
    {
        page_id     => 358282,
        blocks      => [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 349786,
        blocks      => [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'ffea00 amp']
    },
    {
        page_id     => 348684,
        blocks      => [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'F7F7F7 amp']
    },
    {
        page_id     => 348668,
        blocks      => [22, 23, 24, 25, 26, 27, 28, 29, 30, 31],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'CC3333 amp']
    },
    {
        page_id     => 348650,
        blocks      => [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '24af30 amp']
    },
    {
        page_id     => 344741,
        blocks      => [1, 2, 3, 4, 5, 6, 47, 48, 49, 50],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '24af30 amp']
    },
    {
        page_id     => 343941,
        blocks      => [26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'f7d985 amp']
    },
    {
        page_id     => 327101,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 323012,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 321104,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 287178,
        blocks      => [18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 272773,
        blocks      => [20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 272772,
        blocks      => [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'fcc11b amp']
    },
    {
        page_id     => 272771,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'ff0066 amp']
    },
    {
        page_id     => 269946,
        blocks      => [17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'ed9081 amp']
    },
    {
        page_id     => 263082,
        blocks      => [21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'ebebff amp']
    },
    {
        page_id     => 262935,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 261545,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 259994,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 259993,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '315efb amp']
    },
    {
        page_id     => 259992,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', '0050ff amp']
    },
    {
        page_id     => 259991,
        blocks      => [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23],
        form_factor => 'vertical',
        height      => 250,
        limit       => 2,
        designs => ['oldPosterVertical', 'fc2772 amp']
    },

];

sub convert_design {
    my ($design) = @_;

    my $new_design = clone $design;

    $new_design->{titleFontSize}      //= 1;
    $new_design->{urlBackgroundColor} //= 'FFFFFF';
    $new_design->{sitelinksColor}     //= '000000';
    $new_design->{siteBgColor}        //= 'FFFFFF';
    $new_design->{hoverColor}         //= '000000';
    $new_design->{urlColor}           //= '000000';
    $new_design->{noSitelinks}        //= JSON::XS::false;
    $new_design->{imagesFirst}        //= JSON::XS::false;
    $new_design->{linksUnderline}     //= JSON::XS::false;
    $new_design->{favicon}            //= JSON::XS::false;
    $new_design->{fontSize}           //= 1;
    $new_design->{fontFamily}         //= 'arial';
    $new_design->{borderType}         //= 'ad' if (exists $new_design->{borderColor});
    $new_design->{borderRadius}       //= JSON::XS::false if (exists $new_design->{borderColor});
    $new_design->{adaptiveHeight} = delete $new_design->{height} if (exists $new_design->{height});

    foreach (qw(width advSpacing warningCompact imageWidth skin)) {
        delete $new_design->{$_};
    }
    return $new_design;
}

sub args {
    my ($opts) = @_;

    return ('rollback_file:s' => \$opts->{rollback_file},);
}

run(
    sub {
        my ($app, $opts) = @_;

        my $log = $opts->{'rollback_file'};

        if (defined $log) {

            open(my $fh, '<', $log) or die $!;

            while (my $line = <$fh>) {
                chomp($line);

                if ($line =~ /New design ID:\s+(\d+)/) {
                    my $design_id = $1;
                    $app->design_templates->do_action($design_id, 'delete');
                    print logstr "Delete design", $design_id;
                }
                if ($line =~ /Old bk_data for block\s+(R-A-\d+-\d+)\s+(.*)$/) {
                    my $public_id = $1;
                    my $bk_data   = from_json($2);

                    $app->context_on_site_rtb->do_action($public_id, 'edit', 'bk_data', $bk_data);
                    print logstr "Update block", $public_id;
                }
            }

        } else {
            my @skipped_blocks;
            foreach my $settings (@{$SETTINGS}) {
                foreach my $block_id (@{$settings->{blocks}}) {
                    my $block_data = $app->context_on_site_rtb->get(
                        {campaign_id => $settings->{page_id}, id => $block_id},
                        fields => [qw(public_id bk_data design_templates is_custom_bk_data)]
                    );
                    unless ($block_data) {
                        print logstr "Not found block:", {campaign_id => $settings->{page_id}, id => $block_id};
                    }
                    unless ($block_data->{is_custom_bk_data}) {
                        push @skipped_blocks, $block_data->{public_id};
                        next;
                    }
                    print logstr "Old bk_data for block ", $block_data->{public_id}, to_json($block_data->{bk_data});
                    my $bk_data    = from_json($block_data->{bk_data});
                    my $rtb_design = $bk_data->{RtbDesign};
                    my $dsp_info   = $bk_data->{DSPInfo};
                    $bk_data->{DSPInfo} = [grep {$_->{DSPID} == 1} @$dsp_info];
                    # Преобразуем поле RtbDesign, если это необходимо
                    if (ref $rtb_design eq 'HASH') {
                        print logstr 'HASH';
                    } else {
                        print logstr 'JSON';
                        my $design = from_json("{$rtb_design}");
                        $design->{blockId} = $block_data->{public_id};
                        $rtb_design = {
                            @{$block_data->{design_templates}}[0]->{id} => {
                                'name'   => 'default design template',
                                'design' => $design,
                            }
                        };
                    }

                    my $cntr = 1;
                    foreach my $design_name (@{$settings->{designs}}) {
                        my $design_settings = {
                            %{$DESIGN_TEMPLATES->{$DESIGNS->{$design_name}->{template} // 'undef'} // {}},
                            %{$DESIGNS->{$design_name}}
                        };
                        delete $design_settings->{template};
                        $design_settings->{limit}  = $settings->{limit};
                        $design_settings->{height} = $settings->{height}
                          if $design_settings->{name} eq 'adaptive0418';
                        my $new_design = {
                            'block_id'                => $block_id,
                            'caption'                 => $cntr++ . ". " . $DESIGN_CAPTION->{$design_settings->{name}},
                            'design_settings'         => convert_design($design_settings),
                            'filter_tags'             => undef,
                            'form_factor'             => $settings->{form_factor},
                            'is_custom_format_direct' => 1,
                            'order_num'               => 0,
                            'page_id'                 => $settings->{page_id}
                        };
                        my $new_id = $app->design_templates->add(%$new_design);
                        print logstr "New design ID:", $new_id;
                        $rtb_design->{$new_id} = {
                            name   => $new_design->{caption},
                            design => {%$design_settings, blockId => $block_data->{public_id}},
                        };
                    }
                    $bk_data->{RtbDesign} = $rtb_design;
                    $app->context_on_site_rtb->do_action($block_data->{public_id},
                        'edit', 'bk_data', to_json($bk_data, pretty => TRUE));
                }
            }
            print logstr "Skipped blocks not in godmode:", @skipped_blocks if @skipped_blocks;
        }
    }
   )
