#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе

    Исправлям флаг check_statistics для блоков у которых нет статистики

=head1 USAGE

    perl -I./lib ./bin/oneshots/PI-18408_fix_direct_zero_block
    perl -I./lib ./bin/oneshots/PI-18408_fix_direct_zero_block --commit

=head1 OPTIONS

    commit - внести изменения

=cut

use lib::abs qw(../../lib);
use qbit;

use Utils::ScriptWrapper;

run(\&main);

sub main {
    my ($app, $opts) = @_;
    # my @models = grep {$app->$_->can('_add_zero_block')} @{$app->product_manager->get_block_model_accessors};
    my @models =
      map  {$app->$_->product->accessor}
      grep {$app->$_->can('_add_zero_block')} @{$app->product_manager->get_statistics_accessors};
    # my @models = @{$app->product_manager->get_block_model_accessors};
    fix_set_check_statistics($app, \@models);
    for my $accessor (@models) {
        my $model = $app->$accessor;
        my %pages = map {$_->{page_id} => $_} @{
            $model->get_all(
                fields => ["page_id", "multistate", "public_id"],
                filter => {multistate => 'not check_statistics and not deleted', id => 0}
            )
          };
        my @pages = keys %pages;
        my $total = @pages;
        my $list  = check_statistics($accessor, \@pages);
        print logstr("COUNT", $accessor, "total:", $total, "tofix:", scalar(@$list));
        for my $page_id (@$list) {
            my @result;
            if ($opts->{commit}) {
                push @result, "result:", $model->do_action($pages{$page_id}{public_id}, 'set_check_statistics');
            }
            print logstr('block:', $pages{$page_id}{public_id}, "multistate:", $pages{$page_id}{multistate}, @result);
        }
    }
}

sub check_statistics {
    my ($model, $pages) = @_;

    my $ch =
        "select page_id, count(*) as cnt from statistics"
      . " where block_id=0 and product_id='%s' and page_id in (%s)"
      . " group by page_id";
    my $ch_db = "clickhouse_mdb --server=prod -- --format=JSONEachRow | tail -n +2";

    my @result;
    while (my @part = splice @$pages, 0, 5000) {
        my %part = map {$_ => undef} @part;
        my $ch_request = sprintf $ch, $model, join(',', @part);
        my $ch = `echo "$ch_request" | $ch_db`;
        for my $row (split /\n/, $ch) {
            $row = from_json($row);
            if ($row->{cnt}) {
                delete $part{$row->{page_id}};
            }
        }
        push @result, keys %part;
    }
    return \@result;
}

sub fix_set_check_statistics {
    my ($app, $list) = @_;

    foreach my $accessor (@$list) {
        my $model            = $app->$accessor;
        my $multistate_graph = $model->get_multistates_graph_definition();
        foreach my $action_data (@{$multistate_graph->{'multistate_actions'}}) {
            if ($action_data->{'action'} eq 'set_check_statistics') {
                $action_data->{'set_flags'} = ['check_statistics'];
                $action_data->{'from'}      = 'not check_statistics and not deleted';
            }
        }
        $model->multistates_graph($multistate_graph);
    }

    return 1;
}
