package FilterValues;
use qbit;

use base qw(Exporter);
our @EXPORT = qw(
  filter_value
  switch_on_ignore
  );

my $path_to_ignore = [
    # qr/RtbDesign/,
    # qr/Design/,
    #
    # qr/skin$/,
    # qr/layout$/,
    # qr/NNNNNN\.design/,
    #
    # qr/DSPInfo\.PartnerShare$/,
    # qr/DSPInfo\.value$/,
    # qr/DSPInfo\.currency$/,
    # qr/campaign_id$/,
    # qr/PremiumVideoFormat$/,
];

my $path_to_data = [
    [qr/caption/i,          '_caption_'],
    [qr/name/i,             '_name_'],
    [qr/host$/i,            '_host_'],
    [qr/CSS/,               '_CSS_'],
    [qr/Template$/,         '_Template_'],
    [qr/page_id$/,          '_page_id_'],
    [qr/campaign_id$/,      '_page_id_'],
    [qr/blockid$/i,         '_block_id_'],
    [qr/MultiState$/,       '_MultiState_'],
    [qr/value$/,            '_value_'],
    [qr/CPM$/i,             '_CPM_'],
    [qr/Color$/i,           '_Color_'],
    [qr/AlternativeCode$/i, '_AlternativeCode_'],

    [qr/Reward\.CurrencyType$/i,  '_Reward.CurrencyType_'],
    [qr/Reward\.CurrencyValue$/i, '_Reward.CurrencyValue_'],

    [qr/DSPID$/i,            '_DSPID_'],
    [qr/NewsJsonOptionId$/i, '_NewsJsonOptionId_'],
    [qr/Sizes\.Width$/i,     '_Sizes.Width_'],
    [qr/Sizes\.Height$/i,    '_Sizes.Height_'],
    [qr/PICategoryIAB/i,     '_value_'],
    [qr/^\.Width$/i,         '_Width_'],
    [qr/^\.Height$/i,        '_Height_'],
    [qr/^\.AltWidth$/i,      '_AltWidth_'],
    [qr/^\.AltHeight$/i,     '_AltHeight_'],

    [qr/address$/, '_address_'],
    [qr/gps$/,     '_gps_'],

    [qr/photo_list\.formats\.path$/, '_formats.path_'],
];

my $make_ignrore;

sub switch_on_ignore {
    $make_ignrore = 1;
}

sub filter_value {
    my ($path, $data) = @_;

    if ($make_ignrore) {
        for my $re (@$path_to_ignore) {
            if ($path =~ $re) {
                return undef;
            }
        }
    }
    for my $re (@$path_to_data) {
        if ($path =~ $re->[0]) {
            $data = $re->[1];
            last;
        }
    }
    # unless (defined $data) {
    #     $data = '<undef>';
    # }
    return $data;
}

1;
