#!/usr/bin/perl

=head1 пример вызова

    bin/oneshots/PI-18431/PI-18431_get_strict_bk_data.pl
        --root=/home/ie2018/tmp/new_bk_data
        --destination=strict_bk_data.json
        --date=2019-07-01
        --limit=30000

bin/oneshots/PI-18431/PI-18431_get_strict_bk_data.pl --root=/home/ie2018/tmp/bk_data3 --destination=strict_bk_data.json --date=2019-07-01 --limit=30000

=cut

use lib::abs qw(../../../lib .);

use qbit;
use CustomBkData;

main();

sub main {
    my $opts = get_opts('destination', 'date');
    my $bk_data = get_strict_bk_data($opts->{date}, $opts->{limit});
    my $result = param_to_path($bk_data);
    writefile(prepare_path($opts->{root}, $opts->{destination}), to_json($result, pretty => 1));
}

sub get_strict_bk_data {
    my ($date, $limit, $target) = @_;

    my $app  = get_app();
    my $list = get_models($app);

    my @block_data;
    for my $accessor (@$list) {
        my $data = get_block_bk_data($app, $accessor, $date, $limit);
        warn("$accessor: " . scalar(@$data) . "\n");
        push @block_data, @$data;
    }
    return \@block_data;
}

sub get_block_bk_data {
    my ($app, $accessor, $date, $limit) = @_;

    my $al    = $accessor . "_action_log";
    my $pn    = $app->$accessor->get_page_id_field_name;
    my $mw    = $app->$accessor->get_multistate_by_name('working');
    my $table = $app->partner_db->$accessor;
    my $query = $app->partner_db->query->select(
        table  => $table,
        fields => ['id', $pn, 'bk_data'],
        filter => [AND => [[is_custom_bk_data => '=' => \0], [multistate => '&' => \$mw]]],
      )->left_join(
        table   => $app->partner_db->$al,
        fields  => [],
        join_on => [
            AND => [
                ["elem_$pn" => '=' => {$pn  => $table}],
                ["elem_id"  => '=' => {"id" => $table}],
                ["dt"       => ">" => \$date],
                ["action"   => "=" => \"edit"],
            ]
        ],
        filter => ["id" => "!=" => \undef]
      )->distinct;
    $query = $query->limit($limit) if $limit;

    my @data;
    for my $row (@{$query->get_all}) {
        if (my $bk_data = delete $row->{bk_data}) {
            push @data, from_json($bk_data);
        }
    }
    return \@data;
}

sub param_to_path {
    my ($bk_data) = @_;

    my %result;
    for my $row (@$bk_data) {
        append_params(\%result, '', fix_old_design($row));
    }
    my $params = normalize_result(\%result);
    return $params;
}
