package TransformKey;
use qbit;

use base qw(Exporter);
our @EXPORT = qw(
  transform_key
  back_transform_key
  );

my $ts_pos = 0;
my %AdTypeSet = map {$_ => 2**($ts_pos++)} sort qw(
  text
  media
  media-performance
  video
  video-performance
  video-motion
  audio
  );

sub typeset_from_value {
    my ($value) = @_;
    my @result;
    for my $key (sort keys %AdTypeSet) {
        if ($value & $AdTypeSet{$key}) {
            push @result, $key;
        }
    }
    return join '+', @result;
}

sub typeset_to_value {
    my ($type_set) = @_;
    my $value = 0;
    for my $key (keys %AdTypeSet) {
        if ($type_set->{$key}) {
            $value += $AdTypeSet{$key};
        }
    }
    return $value;
}

my $path_to_data = [[qr/AdTypeSet$/, \&typeset_to_value, \&typeset_from_value],];

sub transform_key {
    my ($path, $data) = @_;

    for my $re (@$path_to_data) {
        if ($path =~ $re->[0]) {
            return $re->[1]($data, $path);
        }
    }

    return $data;
}

sub back_transform_key {
    my ($path, $data) = @_;

    for my $re (@$path_to_data) {
        if ($path =~ $re->[0]) {
            return $re->[2]($data, $path);
            # if (ref $data eq 'ARRAY') {
            #     return [map {$re->[2]($_, $path)} @$data];
            # } else {
            #     return $re->[2]($data, $path);
            # }
        }
    }

    return $data;
}

1;
