#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе

    Добавляет на блоки с десктопной версией дизайны по условию из тикета PI-16600

=head1 USAGE

    perl -I./lib ./bin/oneshots/PI-18012_add_designs_for_blocks_in_godmode.pl
    perl -I./lib ./bin/oneshots/PI-18012_add_designs_for_blocks_in_godmode.pl --rollback=file.log

=head1 OPTIONS

    rollback - передать лог-файл предыдущего выполнения скрипта для отката

=cut

use qbit;

use Utils::ScriptWrapper;

my @blocks = (
    [250894, 135],
    [250894, 22],
    [250894, 93],
    [250894, 118],
    [250894, 119],
    [250894, 134],
    [250894, 71],
    [250894, 82],
    [250894, 96],
    [250894, 97],
    [250894, 125],
    [250894, 130],
    [250894, 126],
    [250894, 131],
    [250894, 127],
    [250894, 132],
    [250894, 128],
    [250894, 133],
    [250894, 129],
    [250894, 124],
    [250894, 73],
    [250894, 83],
    [250894, 98],
    [250894, 99],
    [250894, 74],
    [250894, 84],
    [250894, 100],
    [250894, 101],
    [250894, 75],
    [250894, 85],
    [250894, 102],
    [250894, 103],
    [250894, 76],
    [250894, 86],
    [250894, 104],
    [250894, 105],
    [250894, 77],
    [250894, 88],
    [250894, 108],
    [250894, 109],
    [250894, 78],
    [250894, 89],
    [250894, 110],
    [250894, 111],
    [250894, 79],
    [250894, 90],
    [250894, 112],
    [250894, 113],
    [250894, 80],
    [250894, 91],
    [250894, 114],
    [250894, 115],
    [250894, 139],
    [250894, 138],
    [250894, 34],
    [250894, 92],
    [250894, 116],
    [250894, 117],
    [250894, 68],
    [250894, 87],
    [250894, 106],
    [250894, 107],
    [244130, 14],
    [244130, 28],
    [244130, 42],
    [244130, 41],
    [244130, 8],
    [244130, 23],
    [244130, 15],
    [244130, 7],
    [244130, 11],
    [244130, 25],
    [244130, 36],
    [244130, 35],
    [244130, 20],
    [244130, 4],
    [244130, 12],
    [244130, 26],
    [244130, 38],
    [244130, 37],
    [244130, 5],
    [244130, 21],
    [244130, 13],
    [244130, 27],
    [244130, 40],
    [244130, 39],
    [244130, 6],
    [244130, 22],
    [244130, 32],
    [244130, 31],
    [244130, 16],
    [244130, 29],
    [244130, 17],
    [244130, 30],
    [140543, 18],
    [140543, 22],
    [140543, 24],
    [140543, 20],
    [140543, 19],
    [140543, 14],
    [140543, 9],
    [140543, 6],
    [140543, 23],
    [140543, 7],
    [140543, 11],
    [140543, 51],
    [140543, 45],
    [140543, 49],
    [140543, 47],
    [140543, 21],
    [140543, 46],
    [140543, 25],
    [140543, 37],
    [140543, 41],
    [140543, 34],
    [140543, 39],
    [140543, 50],
    [140543, 10],
    [140543, 35],
    [140543, 8],
    [140543, 27],
    [140543, 13],
    [140543, 52],
    [140543, 48],
    [140543, 36],
    [140543, 38],
    [140543, 40],
    [140543, 53],
    [137168, 41],
    [137168, 19],
    [137168, 30],
    [137168, 8],
    [137168, 42],
    [137168, 20],
    [137168, 31],
    [137168, 9],
    [137168, 43],
    [137168, 21],
    [137168, 32],
    [137168, 10],
    [137168, 44],
    [137168, 22],
    [137168, 33],
    [137168, 11],
    [137168, 49],
    [137168, 27],
    [137168, 39],
    [137168, 17],
    [137168, 46],
    [137168, 24],
    [137168, 35],
    [137168, 13],
    [137168, 47],
    [137168, 25],
    [137168, 36],
    [137168, 14],
    [137168, 48],
    [137168, 26],
    [137168, 37],
    [137168, 15],
    [137168, 50],
    [137168, 28],
    [137168, 38],
    [137168, 16],
    [137168, 40],
    [137168, 18],
    [137168, 29],
    [137168, 7],
    [261545, 26],
    [261545, 27],
    [261545, 28],
    [261545, 29],
    [261545, 30],
    [261545, 31],
    [261545, 32],
    [261545, 33],
    [261545, 34],
    [261545, 23],
    [261545, 22],
    [261545, 24],
    [261545, 25],
    [261545, 14],
    [261545, 13],
    [261545, 15],
    [261545, 17],
    [261545, 16],
    [261545, 19],
    [261545, 18],
    [261545, 21],
    [261545, 20],
    [252799, 16],
    [252799, 12],
    [252799, 13],
    [252799, 14],
    [252799, 15],
    [249322, 43],
    [249322, 18],
    [249322, 32],
    [249322, 6],
    [249322, 42],
    [249322, 17],
    [249322, 31],
    [249322, 5],
    [249322, 45],
    [249322, 20],
    [249322, 34],
    [249322, 8],
    [249322, 44],
    [249322, 19],
    [249322, 7],
    [249322, 33],
    [249322, 41],
    [249322, 16],
    [249322, 36],
    [249322, 11],
    [249322, 39],
    [249322, 14],
    [249322, 40],
    [249322, 15],
    [249322, 30],
    [249322, 4],
    [249322, 29],
    [249322, 3],
    [249322, 50],
    [249322, 26],
    [249322, 47],
    [249322, 22],
    [249322, 21],
    [249322, 46],
    [249322, 10],
    [249322, 35],
    [259480, 35],
    [259480, 13],
    [259480, 25],
    [259480, 3],
    [259480, 36],
    [259480, 14],
    [259480, 26],
    [259480, 4],
    [259480, 37],
    [259480, 15],
    [259480, 27],
    [259480, 5],
    [259480, 38],
    [259480, 16],
    [259480, 28],
    [259480, 6],
    [259480, 43],
    [259480, 21],
    [259480, 34],
    [259480, 12],
    [259480, 33],
    [259480, 11],
    [259480, 40],
    [259480, 18],
    [259480, 30],
    [259480, 8],
    [259480, 41],
    [259480, 19],
    [259480, 31],
    [259480, 9],
    [259480, 42],
    [259480, 20],
    [259480, 32],
    [259480, 10],
    [259480, 44],
    [259480, 22],
    [259480, 23],
    [259480, 1],
    [259480, 24],
    [259480, 2],
    [250393, 2],
    [250393, 19],
    [250393, 14],
    [250393, 20],
    [250393, 15],
    [250393, 21],
    [250393, 16],
    [250393, 22],
    [250393, 17],
    [250393, 18],
    [250393, 13],
    [250393, 3],
    [250393, 4],
    [250393, 5],
    [259994, 15],
    [259994, 20],
    [259994, 16],
    [259994, 22],
    [259994, 13],
    [259994, 18],
    [259994, 21],
    [259994, 17],
    [259994, 19],
    [259994, 14],
    [259994, 23],
    [70470,  32],
    [70470,  12],
    [70470,  24],
    [70470,  5],
    [70470,  28],
    [70470,  9],
    [70470,  27],
    [70470,  8],
    [70470,  26],
    [70470,  7],
    [70470,  30],
    [70470,  11],
    [70470,  25],
    [70470,  6],
    [260171, 27],
    [260171, 3],
    [260171, 37],
    [260171, 13],
    [260171, 28],
    [260171, 4],
    [260171, 38],
    [260171, 14],
    [260171, 33],
    [260171, 9],
    [260171, 39],
    [260171, 15],
    [260171, 34],
    [260171, 10],
    [260171, 40],
    [260171, 16],
    [260171, 30],
    [260171, 6],
    [260171, 46],
    [260171, 22],
    [260171, 45],
    [260171, 21],
    [260171, 35],
    [260171, 11],
    [260171, 26],
    [260171, 2],
    [260171, 41],
    [260171, 17],
    [260171, 29],
    [260171, 5],
    [260171, 42],
    [260171, 18],
    [260171, 31],
    [260171, 7],
    [260171, 43],
    [260171, 19],
    [260171, 32],
    [260171, 8],
    [260171, 44],
    [260171, 20],
    [260171, 25],
    [260171, 1],
    [260171, 36],
    [260171, 12],
    [140555, 18],
    [140555, 38],
    [140555, 37],
    [140555, 11],
    [140555, 15],
    [140555, 42],
    [140555, 41],
    [140555, 8],
    [140555, 14],
    [140555, 34],
    [140555, 33],
    [140555, 7],
    [140555, 16],
    [140555, 22],
    [140555, 21],
    [140555, 9],
    [140555, 17],
    [140555, 30],
    [140555, 10],
    [140555, 29],
    [140555, 13],
    [140555, 6],
    [140555, 25],
    [140555, 26],
    [70464,  43],
    [70464,  30],
    [70464,  44],
    [70464,  31],
    [70464,  21],
    [70464,  35],
    [70464,  22],
    [70464,  39],
    [70464,  26],
    [70464,  36],
    [70464,  23],
    [70464,  40],
    [70464,  27],
    [70464,  37],
    [70464,  24],
    [70464,  41],
    [70464,  28],
    [70464,  38],
    [70464,  25],
    [70464,  42],
    [70464,  29],
    [70464,  47],
    [70464,  46],
    [70464,  33],
    [70464,  45],
    [70464,  32],
    [70467,  26],
    [70467,  27],
    [70467,  28],
    [70467,  29],
    [70467,  30],
    [70467,  34],
    [70467,  35],
    [70467,  36],
    [70467,  40],
    [70467,  41],
    [70467,  44],
    [70467,  49],
    [70467,  50],
    [70467,  51],
    [70467,  53],
    [70467,  54],
    [70467,  58],
    [70467,  59],
    [70467,  60],
    [70467,  61],
    [70467,  62],
    [70467,  63],
    [70467,  75],
    [70467,  76],
    [70467,  77],
    [70467,  79],
    [70467,  80],
    [70467,  81],
    [70467,  82],
    [70467,  83],
    [140541, 14],
    [140541, 15],
    [140541, 16],
    [140541, 17],
    [140541, 19],
    [140541, 20],
    [140541, 21],
    [140541, 22],
    [140541, 23],
    [140541, 24],
    [140541, 25],
    [140541, 26],
    [140541, 27],
    [140541, 28],
    [140541, 30],
    [140541, 31],
    [140541, 32],
    [140541, 33],
    [140541, 34],
    [140541, 35],
    [140541, 36],
    [140541, 37],
    [140541, 38],
    [140541, 39],
    [140541, 41],
    [140541, 42],
    [140541, 43],
    [140541, 44],
    [140541, 45],
    [140541, 46],
    [140541, 47],
    [140541, 48],
    [140541, 49],
    [140541, 50],
    [140541, 52],
    [140541, 53],
    [140541, 54],
    [140541, 55],
    [140541, 56],
    [140541, 57],
    [140541, 59],
    [140541, 60],
    [140541, 61],
    [140541, 62],
    [140541, 63],
    [140541, 64],
    [140541, 65],
    [140541, 66],
    [140541, 67],
    [140541, 68],
    [140541, 71],
    [140541, 72],
    [140541, 73],
    [140541, 74],
    [140541, 75],
    [140541, 76],
    [140541, 77],
    [140541, 78],
    [140541, 79],
    [140541, 80],
    [262935, 13],
    [262935, 14],
    [262935, 15],
    [262935, 16],
    [262935, 17],
    [262935, 18],
    [262935, 19],
    [262935, 20],
    [262935, 21],
    [262935, 22],
    [262935, 23],
    [262935, 24],
    [262935, 25],
    [262935, 26],
    [262935, 27],
    [262935, 28],
    [262935, 29],
    [262935, 30],
    [262935, 31],
    [262935, 32],
    [262935, 33],
    [262935, 34],
    [225219, 1],
    [225219, 2],
    [225219, 3],
    [225219, 4],
    [225219, 5],
    [225219, 6],
    [225219, 7],
    [70472,  44],
    [70472,  45],
    [70472,  46],
    [70472,  47],
    [70472,  48],
    [70472,  49],
    [70472,  50],
    [70472,  51],
    [70472,  52],
    [70472,  53],
    [70472,  55],
    [70472,  56],
    [70472,  59],
    [70472,  60],
    [70472,  61],
    [70472,  62],
    [70472,  63],
    [70472,  64],
    [70472,  65],
    [70472,  66],
    [70472,  67],
    [259473, 1],
    [259473, 2],
    [259473, 3],
    [259473, 4],
    [259473, 5],
    [259473, 6],
    [259473, 7],
    [259473, 8],
    [259473, 9],
    [259473, 10],
    [259473, 11],
    [259473, 12],
    [259473, 14],
    [259473, 15],
    [259473, 16],
    [259473, 17],
    [259473, 18],
    [259473, 19],
    [259473, 20],
    [259473, 21],
    [259473, 22],
    [259473, 23],
    [259473, 25],
    [259473, 26],
    [259473, 27],
    [259473, 28],
    [259473, 29],
    [259473, 30],
    [259473, 31],
    [259473, 32],
    [259473, 33],
    [259473, 34],
    [259473, 35],
    [259473, 36],
    [259473, 38],
    [259473, 39],
    [259473, 40],
    [259473, 41],
    [259473, 42],
    [259473, 43],
    [259473, 44],
    [259473, 45],
    [259473, 46],
    [259473, 47],
    [259993, 13],
    [259993, 14],
    [259993, 15],
    [259993, 16],
    [259993, 17],
    [259993, 18],
    [259993, 19],
    [259993, 20],
    [259993, 21],
    [259993, 22],
    [259993, 23],
    [250396, 2],
    [250396, 3],
    [250396, 4],
    [250396, 5],
    [250396, 13],
    [250396, 14],
    [250396, 15],
    [250396, 16],
    [250396, 17],
    [250396, 18],
    [250396, 19],
    [250396, 20],
    [250396, 21],
    [250396, 22],
    [141078, 14],
    [141078, 15],
    [141078, 16],
    [141078, 17],
    [141078, 18],
    [141078, 19],
    [141078, 21],
    [141078, 22],
    [141078, 36],
    [141078, 37],
    [141078, 38],
    [141078, 39],
    [141078, 40],
    [141078, 41],
    [141078, 42],
    [141078, 44],
    [141078, 48],
    [141078, 49],
    [141078, 51],
    [141078, 52],
    [141078, 54],
    [141078, 55],
    [141078, 56],
    [141078, 57],
    [141078, 58],
    [141078, 59],
    [141078, 60],
    [141078, 61],
    [141078, 65],
    [141078, 66],
    [141078, 67],
    [141078, 68],
    [141078, 69],
    [141078, 70],
    [141078, 72],
    [141078, 73],
    [251983, 2],
    [251983, 3],
    [251983, 4],
    [251983, 5],
    [251983, 6],
    [251983, 7],
    [251983, 8],
    [251983, 9],
    [251983, 10],
    [251983, 11],
    [251983, 12],
    [251983, 13],
    [251983, 14],
    [251983, 17],
    [251983, 18],
    [251983, 19],
    [251983, 20],
    [251983, 21],
    [251983, 22],
    [251983, 23],
    [251983, 24],
    [251983, 25],
    [251983, 26],
    [251983, 27],
    [251983, 28],
    [251983, 29],
    [251983, 30],
    [251983, 31],
    [251983, 32],
    [251983, 33],
    [251983, 34],
    [251983, 35],
    [251983, 36],
    [251983, 37],
    [251983, 38],
    [251983, 39],
    [251983, 40],
    [251983, 41],
    [251983, 42],
    [251983, 43],
    [251983, 44],
    [251983, 45],
    [251983, 46],
    [251983, 47],
    [287178, 18],
    [287178, 19],
    [287178, 20],
    [287178, 21],
    [287178, 22],
    [287178, 23],
    [287178, 24],
    [287178, 25],
    [287178, 26],
    [287178, 27],
    [287178, 28],
    [252795, 12],
    [252795, 13],
    [252795, 14],
    [252795, 15],
    [252795, 16],
    [252795, 17],
    [252795, 18],
    [252795, 19],
    [252795, 20],
    [252795, 21],
    [228750, 2],
    [228750, 3],
    [228750, 5],
    [228750, 6],
    [228750, 8],
    [228750, 9],
    [228750, 15],
    [228750, 16],
    [228750, 18],
    [228750, 19],
    [228750, 21],
    [228750, 22],
    [228750, 30],
    [228750, 31],
    [228750, 32],
    [228750, 33],
    [228750, 37],
    [228750, 42],
    [228750, 43],
    [228750, 45],
    [228750, 46],
    [228750, 48],
    [228750, 49],
    [228750, 53],
    [228750, 54],
    [228750, 56],
    [228750, 59],
    [228750, 60],
    [228750, 62],
    [228750, 63],
    [228750, 65],
    [228750, 66],
    [228750, 68],
    [228750, 69],
    [327099, 1],
    [327099, 2],
    [327099, 4],
    [327099, 5],
    [327099, 6],
    [327099, 8],
    [327099, 9],
    [327099, 10],
    [327099, 11],
    [327099, 12],
    [327099, 13],
    [327099, 14],
    [327099, 15],
    [327099, 16],
    [327099, 17],
    [327099, 18],
    [327099, 19],
    [327099, 21],
    [327099, 22],
    [327099, 24],
    [327099, 25],
    [327099, 26],
    [327099, 27],
    [327099, 28],
    [327099, 29],
    [327099, 30],
    [327099, 31],
    [327099, 32],
    [327099, 33],
    [327099, 34],
    [327099, 35],
    [327099, 36],
    [327099, 37],
    [327099, 38],
    [327099, 39],
    [327099, 40],
    [327099, 41],
    [327099, 42],
    [327099, 43],
    [327099, 44],
    [327099, 45],
    [327101, 13],
    [327101, 14],
    [327101, 15],
    [327101, 16],
    [327101, 17],
    [327101, 18],
    [327101, 19],
    [327101, 20],
    [327101, 21],
    [327101, 22],
    [327101, 23],
    [294713, 1],
    [294713, 2],
    [294713, 11],
    [294713, 12],
    [294713, 13],
    [294713, 14],
    [294713, 15],
    [294713, 16],
    [294713, 17],
    [294713, 18],
    [294713, 19],
    [294713, 20],
    [231634, 1],
    [231634, 2],
    [231634, 3],
    [231634, 4],
    [231634, 5],
    [231634, 6],
    [231634, 7],
    [231634, 8],
    [231634, 9],
    [231634, 12],
    [231634, 13],
    [231634, 14],
    [231634, 15],
    [231634, 16],
    [231634, 17],
    [231634, 18],
    [231634, 19],
    [231634, 20],
    [231634, 21],
    [231634, 24],
    [231634, 28],
    [231634, 29],
    [231634, 32],
    [231634, 33],
    [231634, 34],
    [231634, 35],
    [231634, 36],
    [231634, 37],
    [231634, 38],
    [231634, 39],
    [231634, 40],
    [231634, 42],
    [231634, 43],
    [231634, 44],
    [231634, 48],
    [231634, 49],
    [231634, 50],
    [231634, 51],
    [231634, 52],
    [231634, 53],
    [231634, 54],
    [231634, 55],
    [231634, 56],
    [231634, 58],
    [247670, 1],
    [247670, 2],
    [247670, 3],
    [247670, 4],
    [247670, 5],
    [247670, 6],
    [247670, 7],
    [247670, 8],
    [247670, 9],
    [247670, 10],
    [247670, 11],
    [247670, 12],
    [247670, 13],
    [247670, 14],
    [247670, 15],
    [247670, 16],
    [247670, 17],
    [247670, 18],
    [247670, 19],
    [247670, 20],
    [247670, 21],
    [247670, 22],
    [247670, 25],
    [247670, 26],
    [247670, 27],
    [247670, 28],
    [247670, 29],
    [247670, 30],
    [247670, 31],
    [247670, 32],
    [247670, 33],
    [247670, 34],
    [247670, 35],
    [247670, 36],
    [247670, 37],
    [247670, 38],
    [247670, 39],
    [247670, 40],
    [247670, 41],
    [247670, 42],
    [247670, 43],
    [247670, 44],
    [247670, 45],
    [247670, 46],
    [321104, 13],
    [321104, 14],
    [321104, 15],
    [321104, 16],
    [321104, 17],
    [321104, 18],
    [321104, 19],
    [321104, 20],
    [321104, 21],
    [321104, 23],
    [294712, 11],
    [294712, 12],
    [294712, 13],
    [294712, 14],
    [294712, 15],
    [222078, 3],
    [222078, 4],
    [222078, 7],
    [222078, 9],
    [222078, 15],
    [222078, 17],
    [222078, 20],
    [222078, 21],
    [222078, 22],
    [222078, 23],
    [222078, 28],
    [222078, 37],
    [222078, 41],
    [222078, 42],
    [222078, 43],
    [222078, 44],
    [222078, 45],
    [222078, 46],
    [222078, 47],
    [222078, 49],
    [222078, 50],
    [222078, 60],
    [222078, 61],
    [184430, 3],
    [184430, 4],
    [184430, 7],
    [184430, 9],
    [184430, 10],
    [184430, 11],
    [184430, 12],
    [184430, 13],
    [184430, 14],
    [184430, 15],
    [184430, 16],
    [184430, 17],
    [184430, 18],
    [184430, 19],
    [184430, 20],
    [184430, 22],
    [184430, 23],
    [184430, 25],
    [184430, 26],
    [184430, 27],
    [184430, 28],
    [184430, 29],
    [184430, 31],
    [184430, 32],
    [184430, 33],
    [184430, 34],
    [184430, 35],
    [184430, 36],
    [184430, 37],
    [184430, 38],
    [184430, 39],
    [184430, 40],
    [184430, 41],
    [184430, 42],
    [184430, 43],
    [184430, 44],
    [184430, 45],
    [184430, 46],
    [184430, 47],
    [184430, 48],
    [184430, 49],
    [184430, 50],
    [184430, 51],
    [184430, 52],
    [358282, 7],
    [358282, 8],
    [358282, 9],
    [358282, 10],
    [358282, 11],
    [358282, 12],
    [358282, 13],
    [358282, 14],
    [358282, 15],
    [358282, 16],
    [358282, 17],
    [247699, 3],
    [247699, 4],
    [247699, 5],
    [247699, 6],
    [247699, 7],
    [247699, 8],
    [247699, 10],
    [247699, 11],
    [247699, 15],
    [247699, 16],
    [247699, 17],
    [247699, 18],
    [247699, 19],
    [247699, 20],
    [247699, 21],
    [247699, 22],
    [247699, 23],
    [247699, 27],
    [247699, 29],
    [247699, 36],
    [247699, 37],
    [247699, 38],
    [247699, 39],
    [247699, 40],
    [247699, 41],
    [247699, 42],
    [247699, 43],
    [247699, 47],
    [247699, 48],
    [247699, 49],
    [247699, 50],
    [247699, 51],
    [247699, 52],
    [247699, 53],
    [247699, 54],
    [247699, 55],
    [247699, 57],
    [247699, 58],
    [259474, 1],
    [259474, 2],
    [259474, 3],
    [259474, 4],
    [259474, 5],
    [259474, 6],
    [259474, 7],
    [259474, 8],
    [259474, 9],
    [259474, 10],
    [259474, 11],
    [259474, 12],
    [259474, 13],
    [259474, 14],
    [259474, 15],
    [259474, 16],
    [259474, 17],
    [259474, 18],
    [259474, 19],
    [259474, 20],
    [259474, 21],
    [259474, 22],
    [259474, 26],
    [259474, 27],
    [259474, 28],
    [259474, 29],
    [259474, 30],
    [259474, 31],
    [259474, 32],
    [259474, 33],
    [259474, 34],
    [259474, 35],
    [259474, 36],
    [259474, 37],
    [259474, 38],
    [259474, 39],
    [259474, 40],
    [259474, 41],
    [259474, 42],
    [259474, 43],
    [259474, 44],
    [259474, 45],
    [259474, 46],
    [259474, 47],
    [259991, 13],
    [259991, 14],
    [259991, 15],
    [259991, 16],
    [259991, 17],
    [259991, 18],
    [259991, 19],
    [259991, 20],
    [259991, 21],
    [259991, 22],
    [259991, 23],
    [259991, 24],
    [259991, 25],
    [259991, 26],
    [259991, 27],
    [259991, 28],
    [259991, 29],
    [259991, 30],
    [259991, 31],
    [259991, 32],
    [259991, 33],
    [259991, 34],
    [250397, 15],
    [250397, 16],
    [250397, 17],
    [250397, 18],
    [250397, 19],
    [247702, 3],
    [247702, 4],
    [247702, 5],
    [247702, 6],
    [247702, 7],
    [247702, 8],
    [247702, 9],
    [247702, 10],
    [247702, 13],
    [247702, 14],
    [247702, 15],
    [247702, 16],
    [247702, 17],
    [247702, 18],
    [247702, 20],
    [247702, 21],
    [247702, 38],
    [247702, 39],
    [247702, 40],
    [247702, 41],
    [247702, 42],
    [247702, 43],
    [247702, 44],
    [247702, 45],
    [247702, 54],
    [247702, 55],
    [247702, 56],
    [247702, 57],
    [247702, 58],
    [247702, 59],
    [247702, 61],
    [247702, 62],
    [247702, 66],
    [259479, 1],
    [259479, 3],
    [259479, 4],
    [259479, 5],
    [259479, 6],
    [259479, 7],
    [259479, 8],
    [259479, 9],
    [259479, 10],
    [259479, 11],
    [259479, 13],
    [259479, 14],
    [259479, 15],
    [259479, 16],
    [259479, 17],
    [259479, 19],
    [259479, 20],
    [259479, 21],
    [259479, 22],
    [259479, 23],
    [259479, 25],
    [259479, 27],
    [259479, 28],
    [259479, 29],
    [259479, 30],
    [259479, 31],
    [259479, 32],
    [259479, 33],
    [259479, 34],
    [259479, 35],
    [259479, 37],
    [259479, 38],
    [259479, 39],
    [259479, 40],
    [259479, 41],
    [259479, 43],
    [259479, 44],
    [259479, 45],
    [259479, 46],
    [259479, 47],
    [259992, 13],
    [259992, 14],
    [259992, 15],
    [259992, 16],
    [259992, 17],
    [259992, 18],
    [259992, 19],
    [259992, 20],
    [259992, 21],
    [259992, 22],
    [259992, 23],
    [250394, 13],
    [250394, 14],
    [250394, 15],
    [250394, 16],
    [250394, 17],
    [250394, 18],
    [250394, 19],
    [250394, 20],
    [250394, 21],
    [250394, 22]
);

my %rollback_data;
my $rollback_file;

sub set_colors {
    my ($campaign_id, $block_id, $design_id, $design) = @_;
    if ($rollback_file) {
        if (exists($rollback_data{$campaign_id}{$block_id}{$design_id})) {
            if ($design->{name} ne 'adaptive0418') {
                die "Unexpected design $design->{name} for $campaign_id-$block_id-$design_id";
            }
            $design->{hoverColor}         = $rollback_data{$campaign_id}{$block_id}{$design_id}{hoverColor};
            $design->{urlBackgroundColor} = $rollback_data{$campaign_id}{$block_id}{$design_id}{urlBackgroundColor};
        }
    } else {
        if ($design->{name} eq 'adaptive0418') {
            print to_json(
                {
                    campaign_id        => $campaign_id,
                    id                 => $block_id,
                    design_id          => $design_id,
                    hoverColor         => $design->{hoverColor},
                    urlBackgroundColor => $design->{urlBackgroundColor},
                },
                canonical => 1
            ) . "\n";
            $design->{hoverColor}         = 'E7372D';
            $design->{urlBackgroundColor} = 'E7372D';
        }
    }
}

sub args {
    my ($opts) = @_;

    return ('rollback_file:s' => \$opts->{rollback_file},);
}

run(
    sub {
        my ($app, $opts) = @_;

        $rollback_file = $opts->{rollback_file};

        my $blocks_list = join(",\n", map {"($_->[0], $_->[1])"} @blocks);

        my $sql =
            "SELECT campaign_id, id, bk_data, is_custom_bk_data"
          . " FROM context_on_site_rtb"
          . " WHERE (campaign_id, id) in ($blocks_list)";

        my $blocks_with_godmode_data = $app->partner_db->_get_all($sql);
        if ($rollback_file) {
            my $data = readfile($rollback_file);
            for my $line (split("\n", $data)) {
                my $block = from_json($line);
                $rollback_data{$block->{campaign_id}}{$block->{id}}{$block->{design_id}} = {
                    hoverColor         => $block->{hoverColor},
                    urlBackgroundColor => $block->{urlBackgroundColor},
                };
            }
        }

        foreach my $block (@$blocks_with_godmode_data) {
            unless ($block->{is_custom_bk_data}) {
                die "Block $block->{campaign_id}-$block->{id} is not godmode";
            }
            my $bk_data    = from_json($block->{bk_data});
            my $rtb_design = $bk_data->{RtbDesign};
            if (ref $rtb_design eq 'HASH') {
                for my $design_id (keys(%$rtb_design)) {
                    my $design = $rtb_design->{$design_id};
                    next if ($design->{type} // '') eq 'media';
                    set_colors($block->{campaign_id}, $block->{id}, $design_id, $design->{design});
                }
            } else {
                my $design    = from_json("{$rtb_design}");
                my $design_id = 'old_format';
                set_colors($block->{campaign_id}, $block->{id}, $design_id, $design);
                $rtb_design = to_json($design, canonical => 1);
                $rtb_design =~ s/^{|}$//g;
            }

            $bk_data->{RtbDesign} = $rtb_design;
            $block->{bk_data} = to_json($bk_data, pretty => 1);
        }

        $app->partner_db->context_on_site_rtb->add_multi($blocks_with_godmode_data, duplicate_update => TRUE)
          if !$opts->{dry_run};
    }
   )
