use strict;
use warnings;

use qbit;

use Utils::ScriptWrapper;

my %internal_dsps = map {$_ => 1} (
    qw(
      1
      5
      10
      2
      3
      2563070
      2563117
      2563118
      2563130
      2563147
      2563149
      2563153
      2563154
      2563156
      2563180
      2563201
      2563204
      2563229
      2563232
      2563252
      )
);

my $get_rambler_pages_sql = <<SQL;
SELECT page_id
FROM all_pages
WHERE owner_id = 120143188
SQL

my $get_rambler_blocks_sql = <<SQL;
SELECT page_id, id, model
FROM all_blocks
WHERE page_id in (%s)
SQL

run(
    sub {
        my ($app, $opts) = @_;

        # Достаем все пейджи, которые принадлежат рамблеру
        my @rambler_pages = map {$_->{page_id}} @{$app->partner_db->_get_all($get_rambler_pages_sql)};

        # Достаем все блоки, которые принадлежат рамблеру (через page_id)
        my $blocks_with_models =
          $app->partner_db->_get_all(sprintf($get_rambler_blocks_sql, join(",\n", @rambler_pages)));

        # В каких моделях нужно делать апдейт
        my %models = map {$_->{model} => 1} @$blocks_with_models;

        my %pages_to_update;

        for my $model (keys(%models)) {
            # Если у продукта нет настройки DSP, скипаем
            next unless $app->$model->DOES('Application::Model::Role::Has::DSPS');

            my @regular_blocks;
            my @godmode_blocks;

            my $page_id_field_name = $app->$model->get_page_id_field_name();

            my $blocks_list = join(",\n", map {"($_->{page_id}, $_->{id})"} @$blocks_with_models);

            # Достаем все блоки из блочной таблицы вместе с настройками годмода
            my $model_blocks =
                "SELECT $page_id_field_name, id, bk_data, is_custom_bk_data"
              . " FROM $model"
              . " WHERE ($page_id_field_name, id) in ($blocks_list)";

            my $blocks_with_godmode_flag = $app->partner_db->_get_all($model_blocks);

            for my $block (@$blocks_with_godmode_flag) {
                # Если блок в годмоде - апдейтим bk_data
                if ($block->{is_custom_bk_data}) {
                    my $bk_data = from_json($block->{bk_data});
                    my @new_dsp_info;
                    for my $dsp (@{$bk_data->{DSPInfo}}) {
                        # Отфильтровываем внешние DSP
                        if (exists($internal_dsps{$dsp->{DSPID}})) {
                            push @new_dsp_info, $dsp;
                        } else {
                            print logstr(
                                'DELETE_GODMODE_DSP',
                                {
                                    model   => $model,
                                    page_id => $block->{$page_id_field_name},
                                    id      => $block->{id},
                                    dsp_id  => $dsp->{DSPID},
                                }
                            );
                        }
                    }
                    # Если дспшек стало меньше, добавляем блок в список к апдейту годмода
                    if (@{$bk_data->{DSPInfo}} > @new_dsp_info) {
                        $bk_data->{DSPInfo} = \@new_dsp_info;
                        $block->{bk_data} = to_json($bk_data, pretty => 1);
                        push @godmode_blocks, $block;
                    }
                }
                # В список к удалению из block_dsps добавляем в любом случае
                # Даже если блок в годмоде, когда его вернут, внешних дсп там тоже не должно быть
                push @regular_blocks, [$block->{$page_id_field_name}, $block->{id}];

                $pages_to_update{$block->{$page_id_field_name}} = 1;
            }

            # Апдейтим годмоды
            $app->partner_db->$model->add_multi(\@godmode_blocks, duplicate_update => TRUE)
              if @godmode_blocks && !$opts->{dry_run};

            # Чистим block_dsps
            my $regular_blocks_list = join(",\n", map {"($_->[0], $_->[1])"} @regular_blocks);
            my $dsp_list = join(",\n", sort keys(%internal_dsps));
            my $delete =
                "DELETE FROM block_dsps\n"
              . "WHERE (page_id, block_id) IN ($regular_blocks_list)\n"
              . "AND dsp_id NOT IN ($dsp_list)\n";
            print $delete;
            $app->partner_db->_do($delete) if @regular_blocks && !$opts->{dry_run};
        }

        print "PAGES TO UPDATE\n";

        for (sort {$a <=> $b} keys(%pages_to_update)) {
            print "$_\n";
        }
    }
   )
