use strict;
use warnings;

use qbit;

use Utils::ScriptWrapper;

my %dsps_to_remove = map {$_ => 1} (
    qw(
      2
      3
      2563232
      2563149
      2563201
      2563156
      )
);

my @page_id_list = qw(149267 151507 152039 152040 153638 153747 155185 155187 155188
  155707 162320 163064 163893 172864 178516 183892 183922 185103 190904 192948 196508
  197243 197248 206142 209040 213088 213260 213327 215533 215534 216651 217994 220127
  221966 222075 223624 223631 224727 231936 232088 232146 235597 237709 237710 238158
  240314 242817 244169 245352 249430 249431 252040 252729 255531 255657 256144 256145
  258356 258950 260753 261025 261374 261375 262203 262250 264463 265064 265519 265882
  269854 269950 269954 269955 274822 275949 276129 276202 276203 277039 277353 277354
  277355 277356 277357 281768 286150 286573 288427 288701 290744 290890 292029 292030
  292031 292522 294891 295404 295782 295784 322331 330577 330578 335136 347757 353938
  357992 381772 384788 402565 403356 425764 426018 426041);

run(
    sub {
        my ($app, $opts) = @_;

        my %pages_to_update;

        my @model_list = map {$_->{model}} @{
            $app->partner_db->_get_all(
                'SELECT DISTINCT model FROM all_blocks WHERE page_id IN (' . join(',', @page_id_list) . ')'
            )
          };

        for my $model (@model_list) {
            # Если у продукта нет настройки DSP, скипаем
            next unless $app->$model->DOES('Application::Model::Role::Has::DSPS');

            my @regular_blocks;
            my @godmode_blocks;

            my $page_id_field_name = $app->$model->get_page_id_field_name();

            my $block_list = $app->$model->get_all(
                filter => [page_id => 'IN' => \@page_id_list],
                fields => [$page_id_field_name, qw(id bk_data is_custom_bk_data)],
            );

            for my $block (@$block_list) {
                # Если блок в годмоде - апдейтим bk_data
                if ($block->{is_custom_bk_data}) {
                    my $bk_data = from_json($block->{bk_data});
                    my @new_dsp_info;
                    for my $dsp (@{$bk_data->{DSPInfo}}) {
                        # Отфильтровываем внешние DSP
                        if (exists($dsps_to_remove{$dsp->{DSPID}})) {
                            print logstr(
                                'DELETE_GODMODE_DSP',
                                {
                                    model   => $model,
                                    page_id => $block->{$page_id_field_name},
                                    id      => $block->{id},
                                    dsp_id  => $dsp->{DSPID},
                                }
                            );
                        } else {
                            push @new_dsp_info, $dsp;
                        }
                    }
                    # Если дспшек стало меньше, добавляем блок в список к апдейту годмода
                    if (@{$bk_data->{DSPInfo}} > @new_dsp_info) {
                        $bk_data->{DSPInfo} = \@new_dsp_info;
                        $block->{bk_data} = to_json($bk_data, pretty => 1);
                        push @godmode_blocks, $block;
                    }
                }
                # В список к удалению из block_dsps добавляем в любом случае
                # Даже если блок в годмоде, когда его вернут, внешних дсп там тоже не должно быть
                push @regular_blocks, [$block->{$page_id_field_name}, $block->{id}];

                $pages_to_update{$block->{$page_id_field_name}} = 1;
            }

            # Апдейтим годмоды
            $app->partner_db->$model->add_multi(\@godmode_blocks, duplicate_update => TRUE)
              if @godmode_blocks && !$opts->{dry_run};

            # Чистим block_dsps
            my $regular_blocks_list = join(",\n", map {"($_->[0], $_->[1])"} @regular_blocks);
            my $dsp_list            = join(",\n", sort keys(%dsps_to_remove));
            my $delete              = qq(
DELETE FROM block_dsps
WHERE (page_id, block_id) IN ($regular_blocks_list)
AND dsp_id IN ($dsp_list)
);
            print $delete;
            $app->partner_db->_do($delete) if @regular_blocks && !$opts->{dry_run};
        }

        print "PAGES TO UPDATE\n";

        for (sort {$a <=> $b} keys(%pages_to_update)) {
            print "$_\n";
        }
    }
   )
