#!/usr/bin/perl
use qbit;
use Utils::ScriptWrapper;
use PiConstants qw($PREROLL $MIDROLL $MAX_REVENUE_STRATEGY_ID);

my @exclude_pages = (
    # Пейджи НХЛ:
    451940, 490073, 451944, 453404, 490106, 453546, 466242,
    # НГ-канал:
    482623, 486995, 491241, 497635, 497637, 497639,
    # Пейджи с клипами:
    285040, 285067, 285068, 399643, 330065, 414357, 382971, 355605, 417615, 417613, 417617,
);

my $category = 1011;

my $check_midroll = {
    0 => {    # not a blogger
        repeat_after    => 600,
        start_time      => 10,
        count_positions => 3,
        max_duration    => 90,
    },
    1 => {    # is a blogger
    },
};

my $preset_midroll = {
    0 => {    # not a blogger
        repeat_after    => 1800,
        start_time      => 1800,
        count_positions => 2,
        max_duration    => 120,
    },
    1 => {    # is a blogger
        repeat_after    => 600,
        start_time      => 600,
        count_positions => 2,
        max_duration    => 60,
    },
};

my $preset_preroll = {
    0 => {    # not a blogger
        max_duration    => 60,
        count_positions => 2,
    },
    1 => {    # is a blogger
        max_duration    => 60,
        count_positions => 2,
    },
};

run(\&main);

sub main {
    my ($app, $opts) = @_;

    if ($opts->{rollback}) {
        my $result = rollback_from_file($app, $opts->{rollback});
        print logstr("EDITED",  $result->{edit} // 0);
        print logstr("DELETED", $result->{del}  // 0);
    } else {
        my $list = get_list_midroll($app);
        print logstr("FOUND", scalar(@$list));

        my $result = process_block_list($app, $list, $opts);
        print logstr("EDITED", $result->{1}{edit} // 0, $result->{0}{edit} // 0);
        print logstr("ADDED",  $result->{1}{add}  // 0, $result->{0}{add}  // 0);
    }
}

sub rollback_from_file {
    my ($app, $file) = @_;

    my $fh;
    my $model = $app->video_an_site_instream;
    my %result;
    if (open($fh, '<', $file)) {
        my %old_blocks;
        while (my $str = <$fh>) {
            if ($str =~ /\bEDIT_BLOCK\b/) {
                my @row   = split /\t/, $str;
                my $data  = from_json($row[2]);
                my $block = $model->get($row[1], fields => ['*']);
                if ($block and !check_row_for_modification($block, $preset_midroll->{$data->{is_video_blogger}})) {
                    delete @{$data}{qw(page_id id preroll_id is_video_blogger is_custom_bk_data caption)};
                    try {
                        $model->do_action($row[1], "edit", %$data);
                        print logstr("RESTORE", $row[1], to_json($data));
                        $result{edit}++;
                    }
                    catch {
                        my ($e) = @_;
                        print STDERR logstr("ERROR_EDIT_BLOCK", $row[1], $e->message);
                    };
                } else {
                    print logstr("SKIP_RESTORE", $row[1]);
                }
            } elsif ($str =~ /\bADD_BLOCK\b/) {
                my @row = split /[\t\n]/, $str;
                try {
                    $model->do_action($row[1], "delete");
                    print logstr("DELETE", $row[1]);
                    $result{del}++;
                }
                catch {
                    my ($e) = @_;
                    print STDERR logstr("ERROR_DELETE_BLOCK", $row[1], $e->message);
                };
            }
        }
        close $fh;
    }

    return \%result;
}

sub process_block_list {
    my ($app, $list, $opts) = @_;

    my $model = $app->video_an_site_instream;
    my %result;
    my %added;

    for my $row (@$list) {
        last unless --$opts->{debug_count};
        my $public_id = "R-V-$row->{page_id}-$row->{id}";
        if (my $msg = check_row_for_modification($row, $check_midroll->{$row->{is_video_blogger}})) {
            print logstr($msg, $public_id, to_json($row));
        } else {
            try {
                $app->partner_db->transaction(
                    sub {
                        my $block = $model->get($public_id, fields => ['*'], for_update => TRUE);
                        if ($block and !check_row_for_modification($block, $check_midroll->{$row->{is_video_blogger}}))
                        {
                            $model->do_action($public_id, 'edit', %{$preset_midroll->{$row->{is_video_blogger}}})
                              if $opts->{commit};
                        } elsif ($block) {
                            die "CHANGED_BLOCK";
                        } else {
                            die "NO_BLOCK";
                        }
                    }
                );
                print logstr("EDIT_BLOCK", $public_id, to_json($row));
                $result{$row->{is_video_blogger}}{edit}++;
            }
            catch {
                my ($e) = @_;
                print STDERR logstr("ERROR_EDIT_BLOCK", $public_id, to_json($row), $e->message);
            };
        }

        next if $added{$row->{page_id}};
        $added{$row->{page_id}} = 1;

        unless ($row->{preroll_id}) {
            try {
                my $block_id =
                  $opts->{commit}
                  ? $model->add(
                    page_id     => $row->{page_id},
                    caption     => "VH preroll default",
                    category_id => $category,
                    type        => $PREROLL,
                    strategy    => $MAX_REVENUE_STRATEGY_ID,
                    %{$preset_preroll->{$row->{is_video_blogger}}},
                  )
                  : 'fake_public_id';
                print logstr("ADD_BLOCK", $block_id);
                $result{$row->{is_video_blogger}}{add}++;
            }
            catch {
                my ($e) = @_;
                print STDERR logstr("ERROR_ADD_BLOCK", $row->{page_id}, $e->message);
            };
        } else {
            print logstr("SKIP_ADD", "R-V-$row->{page_id}-$row->{preroll_id}");
        }
    }

    return \%result;
}

sub check_row_for_modification {
    my ($row, $check) = @_;

    return "EDIT_SKIP_GM" if $row->{is_custom_bk_data};

    my $result;
    for my $key (keys %$check) {
        unless (defined $row->{$key} and $row->{$key} == $check->{$key}) {
            $result = "EDIT_SKIP_EDITED";
            last;
        }
    }

    return $result;
}

sub get_list_midroll {
    my ($app) = @_;

    my $not_deleted = $app->video_an_site_instream->get_multistates_by_filter('not deleted');

    my $sql = $app->partner_db->query->select(
        table  => $app->partner_db->video_an_site_instream,
        fields => {
            'page_id'           => '',
            'id'                => '',
            'is_custom_bk_data' => '',
            'repeat_after'      => '',
            'start_time'        => '',
            'count_positions'   => '',
            'max_duration'      => '',
            'caption'           => '',
        },
        filter => [
            AND => [
                [page_id     => 'NOT IN' => \\@exclude_pages],
                [type        => '='      => \$MIDROLL],
                [multistate  => 'IN'     => \$not_deleted],
                [category_id => '='      => \$category],
            ]
        ],
      )->join(
        table   => $app->partner_db->video_an_site,
        fields  => [],
        join_on => [id => '=' => {page_id => $app->partner_db->video_an_site_instream}],
        filter => [partner_type => '=' => \'yahosting'],

      )->join(
        table   => $app->partner_db->users,
        fields  => ['is_video_blogger'],
        join_on => [id => '=' => {owner_id => $app->partner_db->video_an_site}],
      )->left_join(
        table   => $app->partner_db->video_an_site_instream,
        alias   => 'preroll',
        fields  => {'preroll_id' => 'id'},
        join_on => [
            AND => [
                [page_id     => '='  => {page_id => $app->partner_db->video_an_site_instream}],
                [type        => '='  => \$PREROLL],
                [category_id => '='  => \$category],
                [multistate  => 'IN' => \$not_deleted],
            ]
        ],
      );

    # warn "\n".($sql->order_by('page_id','id')->get_sql_with_data)[0]."\n"; return [];
    # warn Dumper($sql->get_sql_with_data)."\n";

    return $sql->get_all;
}
