#!/usr/bin/perl

use qbit;
use Utils::ScriptWrapper;

=encoding UTF-8

=head1 DESCRIPTION

    Скрипт нуждается в подключении к PROD базе и МСФ

    Удаляет из дизайнов поля, неподдерживаемые в МСФ

=head1 USAGE

    perl -I./lib ./bin/oneshots/PI-18903_remove_unused_design_fields.pl
    perl -I./lib ./bin/oneshots/PI-18903_remove_unused_design_fields.pl --user_ids=161283 --server=dev
    perl -I./lib ./bin/oneshots/PI-18903_remove_unused_design_fields.pl --page_ids=53100 --server=dev

=head1 OPTIONS

    user_ids   - ограничить работу скрипта только указанными юзерами

=cut

our $DESIGNS;
our $ALL_FIELDS    = {};
our @SITE_VERSIONS = qw(desktop turbo turbo_desktop mobile amp);

sub args {
    my ($opts) = @_;

    return (
        'user_ids:s' => \$opts->{'user_ids'},
        'page_ids:s' => \$opts->{'page_ids'},
        'server:s'   => \$opts->{'server'},
    );
}

sub get_design_fields {
    my ($app, $opts) = @_;
    foreach my $site_version (@SITE_VERSIONS) {
        foreach my $form_factor (qw(horizontal vertical)) {
            my $formats = $app->api_format_system->formats(
                role => 'manager',
                form => $form_factor,
                site => $site_version
            );
            foreach (@{$formats}) {
                foreach my $format (@{$_->{formats}}) {
                    $DESIGNS->{$site_version}->{$format->{name}} //= {};
                }
            }
        }
        foreach my $format (keys %{$DESIGNS->{$site_version}}) {
            my $settings = $app->api_format_system->formats(
                role   => 'manager',
                format => $format,
                site   => $site_version
            );
            foreach (@{$settings->{settings}}) {
                $DESIGNS->{$site_version}{$format}{$_->{name}} = TRUE;
                $ALL_FIELDS->{$_->{name}} = TRUE;
            }
        }
    }
}

sub get_selected_pages {
    my ($app, $opts) = @_;

    return unless $opts->{user_ids} || $opts->{page_ids};

    my $pages = $app->all_pages->get_all(
        fields => ['page_id'],
        filter => [
            'AND',
            [
                ($opts->{user_ids} ? (['owner_id', 'IN', [split ',', $opts->{user_ids}]]) : ()),
                ($opts->{page_ids} ? (['page_id',  'IN', [split ',', $opts->{page_ids}]]) : ()),
            ]
        ]
    );
    my $page_ids = [map {$_->{page_id}} @$pages];

    return $page_ids;
}

run(
    sub {
        my ($app, $opts) = @_;

        die "Need set server stage to 'ts','dev' or 'prod'" unless $opts->{server};

        if ($opts->{server} eq 'prod') {
            my $url = $app->api_format_system->get_option('url');
            $url =~ s/test\.//;
            $app->api_format_system->set_option('url', $url);
        }

        get_design_fields($app, $opts);

        my $filter_pages = get_selected_pages($app, $opts);

        my $selected_pages = @$filter_pages ? " and page_id in (" . (join ',', @$filter_pages) . ")" : " ";

        foreach my $site_version (@SITE_VERSIONS) {
            foreach my $format (keys %{$DESIGNS->{$site_version}}) {
                my @extra_fields =
                  grep {!$DESIGNS->{$site_version}->{$format}->{$_} && $_ ne 'limit'} keys %$ALL_FIELDS;
                my $remove_expression =
                  "JSON_REMOVE(opts, '\$.design_settings." . (join "', '\$.design_settings.", @extra_fields) . "')";
                my $site_version_expression =
"(page_id, block_id) in (select page_id, id from all_blocks where model = 'context_on_site_rtb' and site_version='$site_version')";
                my $format_expression = "opts->>'\$.design_settings.name' = '$format'";
                my $where_expression =
" multistate=0 $selected_pages and $site_version_expression and $format_expression and JSON_EXTRACT(opts, '\$.design_settings."
                  . (join "', '\$.design_settings.", @extra_fields)
                  . "') is not null";
                my $select_rollback_expression =
                    '"select concat(\"update design_templates set opts=' . "'"
                  . '\",opts,\"' . "'"
                  . ' where id=\",id,\";\") from design_templates where '
                  . $where_expression . ';"';

                my $sql_expression =
                  '"update design_templates set opts = ' . $remove_expression . ' where ' . $where_expression . ';"';

                print logstr `echo $select_rollback_expression |mysql_partner2 --server=$opts->{server}`;

                print logstr "EXECUTE: $sql_expression";
                print logstr `echo $sql_expression | mysql_partner2 --server=$opts->{server}` unless $opts->{dry_run};
            }
        }
    }
   );
