#!/usr/bin/perl

use qbit;
use Utils::ScriptWrapper;
use Utils::PublicID;

run(\&main);

sub args {
    my ($opts) = @_;

    return ('input:s' => \$opts->{'input'},);
}

sub main {
    my ($app, $opts) = @_;
    if ($opts->{input}) {
        process_from_file($app, $opts->{input});
    }
}

sub process_from_file {
    my ($app, $filename) = @_;

    my $list = read_file_to_array($filename);
    my $by_accessor = Utils::PublicID::group_public_ids_by_model($app, $list);
    for my $accessor (keys %$by_accessor) {
        print logstr("TRY", $accessor);
        unless ($app->$accessor->get_model_fields->{is_custom_bk_data}) {
            print STDERR logstr("BAD_MODEL", $accessor);
            for my $id (@{$by_accessor->{$accessor}}) {
                print logstr("SKIP_WOGM", $id);
            }
            next;
        }
        my $pn     = $app->$accessor->get_page_id_field_name;
        my %uniq   = map {$_ => undef} @{$by_accessor->{$accessor}};
        my $blocks = $app->$accessor->get_all(
            filter => {public_id => $by_accessor->{$accessor}},
            fields => [$pn, qw(page_id id public_id is_deleted is_protected bk_data is_custom_bk_data)],
        );
        my @deleted;
        my @working;
        my @protected;
        my @notgm;

        for my $row (@$blocks) {
            delete $uniq{$row->{public_id}};
            unless ($row->{is_custom_bk_data}) {
                push @notgm, $row->{public_id};
            } elsif ($row->{is_protected}) {
                push @protected, $row->{public_id};
            } elsif ($row->{is_deleted}) {
                push @deleted, $row;
            } else {
                push @working, $row;
            }
        }

        if (@notgm) {
            print logstr("FOUND_NOTGM", $accessor, scalar(@notgm));
            for my $id (@notgm) {
                print logstr("SKIP_NOTGM", $id);
            }
        }
        if (@protected) {
            print logstr("FOUND_PROTECTED", $accessor, scalar(@protected));
            for my $id (@protected) {
                print logstr("SKIP_PROTECTED", $id);
            }
        }
        if (@deleted) {
            print logstr("FOUND_DELETED", $accessor, scalar(@deleted));
            my @filter;
            for my $row (@deleted) {
                print logstr("MAKE_DELETED", $row->{public_id});
                push @filter, "($row->{page_id},$row->{id})";
            }
            my $update_sql =
              "UPDATE $accessor SET is_custom_bk_data = 0 WHERE ($pn,id) in (" . join(',', @filter) . ")";
            my $result = $app->partner_db->_do($update_sql);
            print logstr("RESULT_UPDATE_DELETED", $accessor, $result);
        }
        if (@working) {
            print logstr("FOUND_WORKING", $accessor, scalar(@working));
            my @filter;
            for my $row (@working) {
                print logstr("MAKE_WORKING", $row->{public_id}, to_json(from_json($row->{bk_data})));
                push @filter, "($row->{page_id},$row->{id})";
            }

            my $update_sql =
              "UPDATE $accessor SET is_custom_bk_data = 0 WHERE ($pn,id) in (" . join(',', @filter) . ")";
            my $result = $app->partner_db->_do($update_sql);
            print logstr("RESULT_UPDATE_WORKING", $accessor, $result);

            my %pages;
            for my $row (@working) {
                try {
                    $app->$accessor->do_action($row->{public_id}, "delete", do_not_update_in_bk => TRUE);
                    print logstr("DELETE_WORKING", $row->{public_id});
                    $pages{$row->{page_id}} = undef;
                }
                catch {
                    my ($e) = @_;
                    print STDERR logstr("ERROR_WORKING", $row->{public_id}, $e->message);
                };
            }

            try {
                $app->partner_db->transaction(
                    sub {
                        $app->all_pages->mark_pages_for_async_update(page_ids => [keys %pages]);
                    }
                );
                print logstr("DONE_MARK_FOR_UPDATE");
            }
            catch {
                my ($e) = @_;
                print STDERR logstr("ERROR_MARK_FOR_UPDATE", $e->message);
            };
        }
    }
}

sub read_file_to_array {
    my ($filename) = @_;

    my $fh;
    open $fh, $filename;
    my @result;
    while (my $str = <$fh>) {
        next if $str =~ /^\s*$/;
        my @row = split /[\t\n]/, $str;
        push @result, $row[0];
    }

    return \@result;
}
