use strict;
use warnings;

use qbit;

use Utils::ScriptWrapper;

my $user_id_avitortb2013 = 198392540;
my $stop_dt              = '2020-03-31';

my $start_directly_model_list = {
    'context_on_site_campaign' => 1,
    'search_on_site_campaign'  => 1,
};

run(
    sub {
        my ($app, $opts) = @_;

        my @pages_to_update;

        my $page_list = $app->partner_db->_get_all(
"select model, page_id from all_pages where owner_id = $user_id_avitortb2013 and is_deleted = 0 and is_stopped = 1"
        );

        for my $page (@$page_list) {
            my $page_model       = $page->{model};
            my $page_id          = $page->{page_id};
            my $action_log_table = $page_model . '_action_log';

            my $action_log_entry = $app->partner_db->_get_all(
                "select id from $action_log_table where elem_id = $page_id
                    and action = 'stop' and user_id = 0 and date(dt) = '$stop_dt'"
            );

            if (@$action_log_entry) {
                print logstr("STARTING $page_model page_id = $page_id");
                unless ($opts->{dry_run}) {
                    try {
                        unless (exists $start_directly_model_list->{$page_model}) {
                            $app->$page_model->do_action($page_id, 'start_testing');
                        }
                        $app->$page_model->do_action($page_id, 'start');
                        push @pages_to_update, $page_id;
                    }
                    catch {
                        my ($e) = @_;
                        print logstr('ERROR: ' . $e->message);
                    };
                }
            }
        }

        print "PAGES TO UPDATE\n";
        print join(',', sort {$a <=> $b} @pages_to_update);
    }
   )
