#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Нужно подключить прод базу, БК и Баланс
  Так же в конфиге нужно выставить stage = production

=cut

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use File::Slurp qw( read_file  write_file );

use qbit;
use Utils::PublicID qw( split_block_public_id );
use Utils::ScriptWrapper;

my @DESIGN_LIST = (
    {
        design_id => 4689568,
        page_id   => 348666,
        block_ids => [14, 38, 39, 40, 42, 43, 44, 45, 1, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13]
    },
    {
        design_id => 4689593,
        page_id   => 259474,
        block_ids => [1, 4, 5, 6, 7, 8, 19, 10, 12, 11, 2, 14, 16, 17, 18, 9, 20, 21, 22]
    },
    {design_id => 4689603, page_id => 400652, block_ids => [2, 8,  4,  9, 5, 10, 6, 11, 7, 12, 21, 22, 1, 3]},
    {design_id => 4689644, page_id => 160328, block_ids => [3, 19, 20, 5, 6, 7,  8, 10]},
    {
        design_id => 4689684,
        page_id   => 348667,
        block_ids => [5, 6, 42, 43, 20, 8, 21, 9, 22, 45, 10, 12, 13, 14, 17, 15, 23, 16]
    },
    {
        design_id => 4689707,
        page_id   => 348663,
        block_ids => [1, 12, 2, 13, 3, 14, 4, 15, 6, 16, 11, 22, 10, 21, 6, 17, 50, 51, 7, 8, 19, 9, 20]
    },
    {
        design_id => 4689718,
        page_id   => 270208,
        block_ids => [26, 27, 2, 13, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 6, 17, 42, 43, 44, 45, 46, 47]
    },
    {
        design_id => 4689732,
        page_id   => 343940,
        block_ids => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22]
    },
    {design_id => 4689760, page_id => 332041, block_ids => [1, 14, 2, 8, 3, 9, 4, 10, 5, 11, 6, 12]},
    {
        design_id => 4689765,
        page_id   => 207494,
        block_ids => [1, 5, 53, 54, 18, 7, 19, 8, 20, 9, 25, 15, 16, 14, 49, 50, 22, 11, 23, 12, 24, 13]
    },
    {
        design_id => 4689836,
        page_id   => 173288,
        block_ids => [3, 4, 62, 63, 27, 6, 28, 7, 29, 8, 58, 59, 31, 10, 32, 11, 33, 12, 15, 13, 34, 14]
    },
    {
        design_id => 4689865,
        page_id   => 348647,
        block_ids => [8, 19, 54, 55, 10, 21, 11, 22, 12, 23, 18, 28, 17, 29, 13, 24, 14, 25, 15, 26, 16, 27]
    },
    {
        design_id => 4689899,
        page_id   => 347787,
        block_ids => [1, 11, 50, 51, 3, 13, 4, 14, 5, 15, 6, 16, 7, 17, 8, 18, 9, 19, 22, 21, 10, 20]
    },
    {
        design_id => 4689929,
        page_id   => 348683,
        block_ids => [2, 13, 3, 14, 4, 15, 5, 16, 6, 17, 7, 18, 8, 19, 9, 20, 10, 21, 11, 22, 12, 23]
    },
    {design_id => 4687889, page_id => 348662, block_ids => [36, 37, 38, 39]},
    {design_id => 4687890, page_id => 348662, block_ids => [42, 43]},
    {design_id => 4687891, page_id => 348662, block_ids => [46, 47, 50, 51]},
    {design_id => 4687851, page_id => 348665, block_ids => [2,  10, 3,  11]},
    {design_id => 4687854, page_id => 348665, block_ids => [5,  13, 7,  15, 21, 22]},
    {design_id => 4687857, page_id => 348665, block_ids => [6,  14, 8,  16]},
    {design_id => 4688389, page_id => 167747, block_ids => [23, 24, 25, 26]},
    {design_id => 4688390, page_id => 167747, block_ids => [29, 30, 31, 32, 38, 39, 16, 14, 12, 7, 5]},
    {design_id => 4688391, page_id => 167747, block_ids => [39, 38]},
    {design_id => 4688469, page_id => 343937, block_ids => [1,  9,  2,  10]},
    {design_id => 4688470, page_id => 343937, block_ids => [4,  12, 36, 37]},
    {design_id => 4688471, page_id => 343937, block_ids => [5,  13]},
    {design_id => 4688566, page_id => 186527, block_ids => [12, 24, 13, 25]},
    {design_id => 4688567, page_id => 186527, block_ids => [15, 27, 17, 29, 18, 30, 70, 68, 28, 16]},
    {design_id => 4688664, page_id => 163132, block_ids => [49, 23, 10, 24]},
    {design_id => 4688665, page_id => 163132, block_ids => [11, 25, 34, 45, 29]},
    {design_id => 4688666, page_id => 163132, block_ids => [14, 39, 16, 28, 41, 40, 36, 25]},
    {design_id => 4688750, page_id => 163133, block_ids => [24, 9,  25, 26, 10]},
    {design_id => 4688751, page_id => 163133, block_ids => [28, 12, 29, 13]},
    {design_id => 4688752, page_id => 163133, block_ids => [38, 41, 30, 14, 39, 44, 42, 45]},
    {design_id => 4688812, page_id => 348643, block_ids => [8,  16, 9,  17]},
    {design_id => 4688813, page_id => 348643, block_ids => [11, 19, 14, 22, 21, 13]},
    {design_id => 4688871, page_id => 347786, block_ids => [6,  8,  7,  9]},
    {design_id => 4688872, page_id => 347786, block_ids => [2,  4]},
    {design_id => 4688873, page_id => 347786, block_ids => [1,  3]},
    {design_id => 4688931, page_id => 348682, block_ids => [2,  15, 3,  16]},
    {design_id => 4688932, page_id => 348682, block_ids => [4,  7,  17, 21, 12, 25, 9, 11, 20, 24]},
    {design_id => 4688933, page_id => 348682, block_ids => [5,  6,  19, 23, 13, 26, 8, 10, 18, 22]},
    {design_id => 4689007, page_id => 247699, block_ids => [15, 3,  16, 4]},
    {design_id => 4689008, page_id => 247699, block_ids => [18, 21, 6,  8]},
    {design_id => 4689009, page_id => 247699, block_ids => [17, 2, 27, 11, 5, 7]},
);

sub args {
    my ($opts) = @_;

    return ('dry_run!' => \$opts->{dry_run},);
}

run(
    sub {
        my ($app, $opts) = @_;

        my $dry_run = $opts->{dry_run};

        my $page_list = [];
        # Пробегаемся по всем дизайнам, которые нужно применить
        for my $design (@DESIGN_LIST) {

            my $page_id = $design->{page_id};
            push @$page_list, $page_id;

            # Вытаскиваем информацию о новом дизайне
            my $new_design_id = $design->{design_id};
            my $new_design = _get_design_by_id($app, $new_design_id);
            # Очищаем ненужные поля
            delete $new_design->{id};
            delete $new_design->{block_id};
            # Сразу обновляем необходимые
            $new_design->{page_id} = $page_id;
            my $new_design_opts = $new_design->{opts};
            $new_design->{opts} = to_json($new_design_opts);

            print logstr('Page ID, new desing ID: ', $page_id, $new_design_id);
            print logstr('New design for page\'s blocks: ', $new_design);
            # Пробегаем по блоками
            for my $block_id (@{$design->{block_ids}}) {
                # Открываем транзакцию
                $app->partner_db->transaction(
                    sub {
                        print logstr('Process block: ', $block_id);
                        # Чистим дизайны блока из таблицы design_templates
                        for my $old_design (_get_designs($app, $page_id, $block_id)) {
                            print logstr('DELETE old design from design_templates. Design ID: ', $old_design->{id});
                            unless ($dry_run) {
                                $app->design_templates->do_action($old_design->{id}, 'delete');
                            }
                        }
                        # Загружаем информацию о блоке
                        my $block = shift $app->context_on_site_rtb->get_all(
                            fields     => [qw(id is_custom_bk_data bk_data)],
                            filter     => ['AND' => [['id', '=', $block_id], ['campaign_id', '=', $page_id]]],
                            multistate => 'not deleted',
                            limit      => 1
                        );

                        # Сохраняем новый дизайн в design_templates
                        $new_design->{block_id} = $block_id;
                        my $new_design_id = 0;
                        unless ($dry_run) {
                            $new_design_id = $app->partner_db->design_templates->add($new_design);
                        }
                        print logstr('ADD new design to design_templates. New design ID: ', $new_design_id);

                        # Проверяем блок в godmode?
                        if ($block->{is_custom_bk_data}) {
                            # Если да - добавляем шаблон в bk_data
                            print logstr('Block in godmode');
                            print logstr('Old bk_data: ', $block->{'bk_data'});
                            my $bk_block = from_json($block->{'bk_data'});
                            # Проверяем наличие дизайна с id=0.
                            if (exists($bk_block->{RtbDesign}{0})) {
                                # Если это медийный дизайн - оставляем его
                                if (exists($bk_block->{RtbDesign}{0}{type})
                                    && ($bk_block->{RtbDesign}{0}{type} eq 'media'))
                                {
                                    my $tmp = $bk_block->{RtbDesign}{0};
                                    $bk_block->{RtbDesign} = {};
                                    $bk_block->{RtbDesign}{0} = $tmp;
                                } else {
                                    # Если это не медийный дизайн - то создаём новый медийный дизайн
                                    print logstr('Corrupted block. Design id=0 is not media: ', $page_id, $block_id);
                                    $bk_block->{RtbDesign} = {};
                                    $bk_block->{RtbDesign}{0} = {
                                        name   => "Ненастраиваемые форматы",
                                        type   => "media",
                                        design => {
                                              horizontalAlign => $block->{horizontal_align}
                                            ? JSON::XS::true
                                            : JSON::XS::false
                                        }
                                    };
                                }
                            } else {
                                $bk_block->{RtbDesign} = {};
                            }
                            $bk_block->{RtbDesign}{$new_design_id} = {
                                design => $new_design_opts->{design_settings},
                                name   => $new_design->{caption},
                                type   => $new_design->{type}
                            };
                            print logstr('New bk_data RtbDesign: ', to_json($bk_block->{RtbDesign}));
                            unless ($dry_run) {
                                my $public_id = "R-A-$page_id-$block_id";
                                $app->context_on_site_rtb->do_action($public_id, 'edit', 'bk_data',
                                    to_json($bk_block, pretty => TRUE));
                            }
                        }
                    }
                );
            }
        }
        print logstr(join(',', @$page_list));
    }
   );

sub _get_design_by_id {
    my ($app, $id) = @_;

    return shift @{
        $app->design_templates->get_all(
            fields => [qw(id page_id block_id caption opts type)],
            filter => {
                id         => $id,
                multistate => 'not deleted'
            }
        )
      };
}

sub _get_designs {
    my ($app, $page_id, $block_id) = @_;

    return @{
        $app->design_templates->get_all(
            fields => [qw(id page_id block_id)],
            filter => {
                page_id    => $page_id,
                block_id   => $block_id,
                multistate => 'not deleted'
            }
        )
      };
}
