#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use qbit;
use Utils::Oneshots::AddBlockBySample;
use Utils::ScriptWrapper 'oneshot';

my $SAMPLE_BLOCKS = join ',', map {"R-V-575977-$_"} 1 .. 12;

sub args {
    my ($opts) = @_;

    return (
        'page_ids=s@' => \$opts->{page_ids},
        'page_list=s' => \$opts->{page_list},
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        if (!$opts->{page_ids} && !$opts->{page_list}) {
            die 'Pages are not provided';
        }

        Utils::Oneshots::AddBlockBySample::main(
            $app,
            {
                dry_run => $opts->{dry_run},
                sample  => $SAMPLE_BLOCKS,
                ($opts->{page_ids} ? (page_ids => join(',', @{$opts->{page_ids}})) : ()),
                ($opts->{page_list} ? (page_list => $opts->{page_list}) : ()),
                skip_empty           => TRUE,
                delete_blocks        => TRUE,
                delete_blocks_filter => [category_id => '<>' => 1015],
                make_readonly        => TRUE,
            }
        );
    }
   );
