#!/bin/bash

IFS=$'\n'
split_count=20

function call_part {
  mkdir "$1" || echo $!
  cd "$1" || echo $!
  shift
  echo "$*" > page_list
  ../bin/oneshots/PI-22557_copy_blocks.pl --page_list page_list &
  cd ..
}

pages=($( cat ./bin/oneshots/PI-22557_copy_blocks.txt ))

chunk_size=$(( ${#pages[@]} / split_count ))
(( split_count-- ))

for (( i = 0; i < split_count; i++ ))
do
  offset=$(( i * chunk_size ))
  call_part "$i" "${pages[@]:$offset:$chunk_size}"
done
offset=$(( split_count * chunk_size ))
chunk_size=$(( ${#pages[@]} - offset ))
call_part "$split_count" "${pages[@]:$offset:$chunk_size}"
