#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Скрипт для замены дизайнов row на native по списку.

=head1 USAGE

  perl -Ilib bin/oneshots/PI-22601_change_design_row_to_native.pl --block_list=block_list.tsv

=head1 OPTIONS

  block_list - Файл со списком блоков

=cut

use Pod::Usage;

use qbit;
use Utils::ScriptWrapper;
use Utils::Oneshots::ChangeDesignRowToNative;

run(\&Utils::Oneshots::ChangeDesignRowToNative::change_designs);

sub prepare_args {
    my ($opts) = @_;

    my @list;
    if ($opts->{rollback} || $opts->{update}) {
    } elsif (!$opts->{block_list}) {
        die "You must specify 'block_list'\n";
    } elsif (!-r $opts->{block_list}) {
        die "Wrong file path '$opts->{block_list}'\n";
    } else {
        open(my $FH, "<", $opts->{block_list});
        binmode($FH, ":utf8");
        my $row = <$FH>;
        $row =~ s/\s+$//;
        my @header = split /\t/, $row;
        while ($row = <$FH>) {
            $row =~ s/\s+$//;
            my %row;
            @row{@header} = split /\t/, $row;
            push @list, \%row;
        }
        close $FH;
    }
    $opts->{list} = \@list;
}

sub args {
    my ($opts) = @_;
    return (
        'block_list:s' => \$opts->{block_list},
        'update:s'     => \$opts->{update},
    );
}
