#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use qbit;
use Utils::Oneshots::AddBlockBySample;
use Utils::ScriptWrapper 'oneshot';

my $SAMPLE_BLOCKS = 'R-V-576056-3,R-V-576056-4';

sub args {
    my ($opts) = @_;

    return ('page_ids=s' => \$opts->{page_ids});
}

run(
    sub {
        my ($app, $opts) = @_;

        if (!$opts->{page_ids}) {
            die 'Pages are not provided';
        }

        foreach my $page_id (split ',', $opts->{page_ids}) {
            my $page = $app->video_an_site->get({id => $page_id}, fields => ['multistate']);
            next unless $page->{multistate} & 1;

            Utils::Oneshots::AddBlockBySample::main(
                $app,
                {
                    dry_run              => $opts->{dry_run},
                    sample               => $SAMPLE_BLOCKS,
                    page_ids             => $page_id,
                    delete_blocks        => TRUE,
                    delete_blocks_filter => [category_id => '=' => 1013],
                }
            );
        }
    }
   );
