#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Скрипт для замены имен старых дизайнов по списку.

=head1 USAGE

  perl -Ilib bin/oneshots/PI-23023_change_design_drop_old_format.pl --ticket=PI-23293 --block_list=block_list.tsv
  perl -Ilib bin/oneshots/PI-23023_change_design_drop_old_format.pl --ticket=PI-23293 --rollback=result.txt
  perl -Ilib bin/oneshots/PI-23023_change_design_drop_old_format.pl --ticket=PI-23293 --block_list=block_list.tsv --fix_sv='{"grid":{"height":290}}'

=head1 OPTIONS

  block_list - Файл со списком блоков

=cut

use Pod::Usage;

use qbit;
use Utils::ScriptWrapper;
use Utils::Oneshots::ChangeDesignDropOldFormat;

run(\&Utils::Oneshots::ChangeDesignDropOldFormat::change_designs);

sub prepare_args {
    my ($opts) = @_;

    my @list;
    if ($opts->{rollback}) {
    } elsif (!$opts->{block_list}) {
        die "You must specify 'block_list'\n";
    } elsif (!-r $opts->{block_list}) {
        die "Wrong file path '$opts->{block_list}'\n";
    } else {
        open(my $FH, "<", $opts->{block_list});
        binmode($FH, ":utf8");
        my $row = <$FH>;
        $row =~ s/\s+$//;
        my @header = split /\t/, $row;
        if (@header == 1 && $header[0] ne 'public_id') {
            die "Wrong file format\n";
        }
        while ($row = <$FH>) {
            $row =~ s/\s+$//;
            next unless $row;
            my %row;
            if (@header == 1) {
                # в файле public_id блока
                my @v = split /-/, $row;
                @row{qw(page_id block_id)} = @v[2, 3];
            } else {
                @row{@header} = split /\t/, $row;
            }
            push @list, \%row;
        }
        close $FH;
    }
    $opts->{list} = \@list;

    if ($opts->{formats}) {
        $opts->{formats} = [split /,/, $opts->{formats}];
    }

    if ($opts->{mode} && !$Utils::Oneshots::ChangeDesignDropOldFormat::MODES{$opts->{mode}}) {
        die "Mode must in " . join(',', sort keys %Utils::Oneshots::ChangeDesignDropOldFormat::MODES) . "\n";
    }

    for my $fix (qw(fix_sv)) {
        if ($opts->{$fix}) {
            $opts->{$fix} = from_json($opts->{$fix});
        }
    }
}

sub args {
    my ($opts) = @_;
    return (
        'block_list:s' => \$opts->{block_list},
        'formats:s'    => \$opts->{formats},
        'mode:s'       => \$opts->{mode},
        'fix_sv:s'     => \$opts->{fix_sv},
        'clear_gm!'    => \$opts->{clear_gm},
    );
}
