#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use qbit;
use Utils::Oneshots::AddBlockBySample;
use Utils::ScriptWrapper 'oneshot';

my $SAMPLE_PAGE = 576112;
my $PAGE_IDS    = get_page_ids();

run(
    sub {
        my ($app, $opts) = @_;

        my $sample_blocks = join(
            ',',
            map {$_->{'public_id'}} @{
                $app->video_an_site_instream->get_all(
                    fields => [qw(public_id)],
                    filter => {page_id => $SAMPLE_PAGE, multistate => 'working', category_id => 1013}
                )
              }
        );

        print logstr('SAMPLE_BLOCKS: ', $sample_blocks);

        Utils::Oneshots::AddBlockBySample::main(
            $app,
            {
                dry_run                  => $opts->{dry_run},
                sample                   => $sample_blocks,
                page_ids                 => join(',', @$PAGE_IDS),
                page_multistate_filter   => 'working',
                delete_blocks            => TRUE,
                delete_blocks_from_model => 'video_an_site_instream',
                delete_blocks_filter     => [category_id => '=' => 1013],
            }
        );
    }
   );

sub get_page_ids {
    return [
        qw(
          293661
          337990
          337933
          139995
          337891
          276119
          260166
          337812
          337942
          259869
          293684
          337952
          337995
          338040
          266915
          337978
          337969
          337963
          338031
          267924
          287074
          338045
          338036
          337985
          270333
          293668
          338011
          338042
          337852
          337908
          259773
          337959
          293335
          338005
          260165
          272769
          293686
          539827
          277554
          293672
          337955
          338041
          267184
          337945
          267051
          291919
          338043
          337858
          269587
          338048
          338047
          337825
          337860
          337841
          269897
          259856
          272256
          338024
          276178
          259865
          275930
          338044
          293667
          337999
          260002
          539861
          337833
          293635
          293617
          259864
          260087
          263882
          337829
          337905
          337983
          337937
          337848
          260103
          338035
          293631
          337854
          272257
          260099
          337816
          337932
          276150
          293660
          293665
          263884
          293636
          293640
          337972
          337924
          267071
          337899
          337861
          337901
          337887
          337895
          337885
          266894
          539955
          260244
          270922
          260227
          261444
          273731
          293658
          274925
          337890
          337923
          263018
          337927
          260228
          269643
          337902
          287341
          539810
          275209
          337896
          293642
          337913
          293638
          263192
          260077
          337889
          539806
          337844
          260223
          337915
          337900
          337856
          337917
          539857
          260230
          260225
          270765
          260243
          259601
          337925
          539808
          270900
          337914
          260226
          268575
          539785
          337934
          337929
          260215
          338020
          338015
          269638
          337837
          293639
          337911
          260232
          539831
          293659
          337926
          337949
          539794
          539800
          260229
          338037
          337906
          337922
          268504
          293637
          269605
          337930
          337931
          337916
          261452
          338038
          337919
          337892
          337904
          267914
          260224
          337894
          293666
          539802
          267075
          337921
          )
    ];
}
