#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use qbit;
use Utils::Oneshots::AddBlockBySample;
use Utils::ScriptWrapper 'oneshot';

my $SAMPLE_PAGE = 575977;

sub args {
    my ($opts) = @_;

    return (
        'page_ids=s@' => \$opts->{page_ids},
        'page_list=s' => \$opts->{page_list},
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        if (!$opts->{page_ids} && !$opts->{page_list}) {
            die 'Pages are not provided';
        }

        my $sample_blocks = join(
            ',',
            map {$_->{'public_id'}} @{
                $app->video_an_site_instream->get_all(
                    fields => [qw(public_id)],
                    filter => {page_id => $SAMPLE_PAGE, multistate => 'working',}
                )
              }
        );

        print logstr('SAMPLE_BLOCKS: ', $sample_blocks);

        Utils::Oneshots::AddBlockBySample::main(
            $app,
            {
                dry_run => $opts->{dry_run},
                sample  => $sample_blocks,
                ($opts->{page_ids} ? (page_ids => join(',', @{$opts->{page_ids}})) : ()),
                ($opts->{page_list} ? (page_list => $opts->{page_list}) : ()),
                page_multistate_filter => 'working',
                skip_empty             => TRUE,
                delete_blocks          => TRUE,
            }
        );
    }
   );
