#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

    Добавляет во все шаблоны опцию disable-video

=head1 USAGE

    perl -Ilib bin/oneshots/PI-23286_add_option_disable_video.pl --blocks=block_list.txt --ticket=PI-23286

=head1 OPTIONS

    blocks - список блоков для работы

=cut

use lib::abs qw(
  ../lib
  );

use qbit;
use Utils::ScriptWrapper;
use Utils::Oneshots::UpdateContentTemplate;

run(\&Utils::Oneshots::UpdateContentTemplate::update_content_template);

sub args {
    my ($opts) = @_;

    return ('blocks:s' => \$opts->{'blocks'});
}

sub prepare_args {
    my ($opts) = @_;

    my @list;
    if ($opts->{rollback}) {
    } elsif (!$opts->{blocks}) {
        die "You must specify 'blocks'\n";
    } elsif (!-r $opts->{blocks}) {
        die "Wrong file path '$opts->{blocks}'\n";
    } else {
        open(my $FH, "<", $opts->{blocks});
        binmode($FH, ":utf8");
        my @list;
        while (my $row = <$FH>) {
            $row =~ s/\s+$//;
            push @list, $row if $row;
        }
        close $FH;
        $opts->{blocks} = \@list;
    }
}
