#!/usr/bin/perl

use lib::abs qw(../lib);

use qbit;
use Application;

my $mock = {
    '/api/v1/ui/fields'       => [{traffic_types => ['web'],},    {traffic_types => ['sdk'],}],
    '/api/v1/yt/inner_owners' => [{owners        => ['avonav'],}, {owners        => ['adinside'],},],
};

sub main {

    my $app = Application->new();
    $app->pre_run();
    $app->set_cur_user({id => 0});

    mock_data();

    my $r1 = get_data($app);
    sleep(5);
    my $r2 = get_data($app);

    if ($r1 eq $r2) {
        print "Same result  - fail\n", $r1;
    } else {
        print "Diff result  - good\n", $r1, $r2;
    }
}

sub get_data {
    my ($app) = @_;

    return to_json(
        $app->context_on_site_campaign->get_fields_defaults(
            {
                fields => ['is_moneymap_required', 'moneymap'],
                attributes => {login => 'adinside'},
            }
        ),
        pretty => TRUE
    );
}

sub mock_data {
    no strict 'refs';
    no warnings 'redefine';
    require QBit::Application::Model::API::Yandex::MoneyMap;
    require QBit::Application;
    *{'QBit::Application::check_rights'} = sub {1};
    *{'QBit::Application::Model::API::Yandex::MoneyMap::call'} = sub {
        my ($self, $method) = @_;
        return shift @{$mock->{$method}};
    };
}

main();
