#!/usr/bin/perl

# CREATE TABLE `_tmp_design_last_stat` (
#     `design_id` bigint(20) unsigned NOT NULL,
#     `last_stat` datetime DEFAULT NULL,
#     PRIMARY KEY (`design_id`)
# ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

use lib::abs qw(
  ../../lib
  ../../local/lib/perl5/
  );

use qbit;
use Utils::ScriptWrapper;

use PiConstants qw(
  $MYSQL_MIN_DATETIME
  );

my $LIMIT      = 10000;
my $PERIOD     = 365 * 2;
my $STAT_LIMIT = 500000;

sub args {
    my ($opts) = @_;

    return (
        'designs=i@' => \$opts->{designs},
        'limit=i'    => \$opts->{limit},
    );
}

sub prepare_args {
    my ($opts) = @_;

    if ($opts->{designs}) {
        $opts->{designs} = [split /,/, join ',', @{$opts->{designs}}];
    }
}

run(
    sub {
        my ($app, $opts) = @_;

        my $limit = $opts->{limit} // $LIMIT;
        my $start_date = date_sub(curdate(), day => $PERIOD, oformat => 'db');
        my $finish_date = curdate(oformat => 'db');
        my $offset = 0;

        while (
            my @list = @{
                $app->design_templates->get_all(
                    ($opts->{designs} ? (filter => [AND => [[id => IN => $opts->{designs}]]]) : ()),
                    fields   => [qw(id page_id)],
                    order_by => [qw(id)],
                    limit    => $limit,
                    offset   => $offset,
                )
            }
          )
        {
            print logstr {
                offset => $offset,
                size   => scalar @list,
            };
            $offset += scalar @list;

            my $design_ids = [map {$_->{id}} @list];

            # Поход за статой с разбивкой по дизайнам и месяцам
            my $stat = $app->bk_statistics->get_statistics2(
                dimension_fields => ['date|month'],
                entity_fields    => ['design_id'],
                fields           => ['shows'],
                levels           => [
                    {
                        filter => [
                            AND => [
                                [design_id => '<>' => 0],
                                [page_id   => IN   => array_uniq(map {$_->{page_id}} @list)],
                                [design_id => IN   => $design_ids],
                            ]
                        ],
                        id => 'payment',
                    },
                ],
                limits => {
                    limit  => $STAT_LIMIT,
                    offset => 0,
                },
                order_by => [
                    {
                        field => 'date',
                        dir   => 'desc',
                    }
                ],
                period => [$start_date, $finish_date],
            );

            my %designs;

            # Заполнение дат по полученным данным статистики
            foreach my $r (@{$stat->{points}}) {
                my $design_id = $r->{dimensions}{design_id};
                my $date      = $r->{dimensions}{date}[0];
                $designs{$design_id} = $date
                  if ((!$designs{$design_id} || $designs{$design_id} lt $date)
                    && $r->{measures}[0]{shows});
            }

            # Заполнение оставшихся дефолтными значениями
            $designs{$_} //= $MYSQL_MIN_DATETIME foreach @$design_ids;

            # Запись результата
            my $query = 'INSERT INTO `_tmp_design_last_stat` (`design_id`, `last_stat`) VALUES (?, ?)';
            $app->partner_db->_do($query, $_, $designs{$_}) foreach keys %designs;
        }
    }
   );
