#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

 ваншот который ищет пользователей из каждой категории и создает для них оферту и допник для проверки

 пример запуска
 perl -Ilib bin/oneshots/PI-25718_make_sample_comtract.pl
=cut

use lib::abs qw(../../lib);

use LWP::UserAgent;

use qbit;
use Pod::Usage;
use Utils::ScriptWrapper;

my $types = {
    non_res => {
        sub => sub {
            my ($app, $user) = @_;
            return $app->documents->is_nonresident($user->{active_contract});
          }
    },
    ph_res => {
        sub => sub {
            my ($app, $user) = @_;
            my $pt = $user->{active_contract}{Person}{type} // '';
            return $app->documents->is_resident($user->{active_contract}) && $pt eq 'ph';
          }
    },
    osn_res => {
        sub => sub {
            my ($app, $user) = @_;
            my $pt = $user->{active_contract}{Person}{type} // '';
            my $nds = $user->{active_contract}{Contract}{nds};
            return $app->documents->is_resident($user->{active_contract}) && $pt eq 'ur' && $nds;
          }
    },
    usn_res => {
        sub => sub {
            my ($app, $user) = @_;
            my $pt = $user->{active_contract}{Person}{type} // '';
            my $nds = $user->{active_contract}{Contract}{nds};
            return $app->documents->is_resident($user->{active_contract}) && $pt eq 'ur' && !$nds;
          }
    },
};

run(\&main);

sub args {
    my ($opts) = @_;
    return ();
}

sub prepare_args {
    my ($opts) = @_;
    $opts->{ticket} = 'PI-25718';
}

sub get_user_list {
    my ($app, $last_id) = @_;

    return $app->partner_db->users->get_all(
        fields => ['id', 'login'],
        filter => [AND => [[id => '>' => \$last_id], [is_games => '=' => \1],]],
        order_by => ['id'],
        limit    => 100,
    );
}

sub prepare_user {
    my ($app) = @_;

    my $count   = 0;
    my $last_id = 0;
    while (my @nt = grep {!$types->{$_}{has}} keys $types) {
        my $list = get_user_list($app, $last_id);
        print STDERR logstr('FOUND', $last_id);
        for my $user (@$list) {
            $count++;
            $last_id = $user->{id};
            print STDERR logstr('TRY', $last_id, $user->{login});
            if (my $u = $app->users->check_game_offer($user)) {
                if ($u->{has_game_offer}) {
                    last;
                }
                for my $t (@nt) {
                    if ($types->{$t}{sub}($app, $u)) {
                        if (my $id = make_contract($app, $u)) {
                            print logstr('CONTRACT', $t, $user->{login}, $user->{id}, $u->{client_id}, $id);
                            $types->{$t}{has} = $u;
                            @nt = grep {!$types->{$_}{has}} keys $types;
                            last;
                        }
                    }
                }
            }
            last unless @nt;
        }
        if ($count > 10000) {
            warn 'too long';
            last;
        }
    }
}

sub make_contract {
    my ($app, $user) = @_;
    my $id;
    try {
        $id = $app->users->accept_game_offer($user);
    }
    catch {
        my ($e) = @_;
        $id = undef;
        print STDERR logstr('FAIL', $user, $e->message);
    };
    return $id;
}

sub main {
    my ($app, $opts) = @_;
    prepare_user($app);
}

sub silent {

    no warnings 'redefine';
    no strict 'refs';

    require QBit::Application::Model::API::HTTP;

    *{'QBit::Application::Model::API::HTTP::INFO'} = sub { };
}
