#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

 ваншот который проставляет приложениям иконку, разработчика и store_id

 пример запуска
 perl bin/oneshots/PI-26189_set_new_fields_for_mobile_apps.pl
    --dry_run - no actual update, just try to fetch data from SAAS
    --limit=n - exit after processing n mobile_apps (quick test)
=cut

use utf8;
use strict;
use warnings;
use lib::abs '../../lib';
use qbit;
use Utils::ScriptWrapper;

{
    no strict 'refs';
    no warnings 'redefine';
    require QBit::Application::Model::API::HTTP;
    *{'QBit::Application::Model::API::HTTP::INFO'} = sub { };
}

sub main {
    my ($app, $opts) = @_;

    my $mobile_apps = $app->mobile_app->partner_db_table->get_all(
        fields => [qw(id store_id multistate type opts)],
        filter => [
            OR => [
                [{json_extract => [opts => \'$.developer']}, IS => \undef],
                [{json_extract => [opts => \'$.icon']},      IS => \undef],
                [AND => [[type => '=', \2], [{json_extract => [opts => \'$.apple_store_id']}, IS => \undef]]]
            ]
        ]
    );
    print logstr("FOUND:", scalar(@$mobile_apps) . " apps to patch");

    my ($processed, $failed) = (0, 0);

    for my $current_app (@$mobile_apps) {
        try {
            my $saas_data = $app->mobile_app->api_rmp->get_app_info(
                type     => $current_app->{type},
                store_id => $current_app->{store_id}
            );
            if (%$saas_data) {
                $app->mobile_app->partner_db_table->edit(
                    $current_app->{id} => {
                        opts => {
                            json_set => [
                                'opts',
                                \'$.developer' => \$saas_data->{developer},
                                \'$.icon'      => \$saas_data->{icon},
                                (
                                    $current_app->{type} == 2
                                    ? (\'$.apple_store_id' => \$saas_data->{apple_store_id})
                                    : ()
                                )
                            ]
                        }
                    }
                ) unless $opts->{dry_run};
            } else {
                $failed++;
                print STDERR logstr('NO_DATA:', @$current_app{qw(id store_id type multistate)});
            }
        }
        catch {
            my ($e) = @_;
            $failed++;
            print STDERR logstr("ERROR:", $current_app->{id}, $e->message);
        };
        $processed++;
        print logstr("PROGRESS:", "processed $processed/" . scalar(@$mobile_apps) . ", failed=$failed ")
          if $processed % 50 == 0;
        last if $opts->{limit} && $processed >= $opts->{limit};
    }
    print logstr("PROGRESS:", "processed=$processed failed=$failed ");
}

sub prepare_args {
    my ($opts) = @_;
    $opts->{ticket} = 'PI-26189';
    #    $opts->{over_logs} = 1;
}

run(\&main);
