#!/usr/bin/perl

use lib::abs qw(../../lib);

use qbit;
use Application;
use Utils::ScriptWrapper;
use Utils::XLS;

my $separate_cpm_ru = q {
<b style="color:#2F3747; font-size:21px;"><span>Раздельный CPM</span></b><br><br>
<span>
    Стратегия «Раздельный CPM» перестанет поддерживаться.
    Для всех блоков, на которых была установлена эта стратегия, будет установлена стратегия «Авто CPM».
    При необходимости вы сможете изменить стратегию в настройках и установить минимальный CPM — порог будет единый как для медийной рекламы, так и для текстово-графических объявлений.
    В приложении к письму мы приложили список блоков, для которых установлена такая стратегия.
</span><br><br>
};

my $brands_and_categories_ru = q {
<b style="color:#2F3747; font-size:21px;"><span>Ограничения по брендам и тематикам</span></b><br><br>
<b style="color:#2F3747;">Для всего приложения</b><br>
<ul>
    <li style="padding-bottom:15px;"><span>Сохраняются заданные ограничения по доменам и Bundle ID.</span></li>
    <li><span>После миграции появится новая возможность – вы сможете самостоятельно задать ограничение по тематикам сразу для всего приложения.</span></li>
</ul>
<b style="color:#2F3747;">Для отдельного рекламного блока</b><br>
<ul>
    <li style="padding-bottom:15px;"><span>
        Перестанут поддерживаться ограничения по тематикам и брендам.
        В приложении к письму вы найдете файл, в котором указаны ваши рекламные блоки и ограничения по тематикам и брендам на них.
    </span></li>
    <li><span>
        Сразу после миграции вы сможете установить ограничения на уровне всего приложения — настройки будут применены для всех его рекламных блоков.
        Читайте подробнее о том,
        <a href="https://yandex.ru/support/partner/inapp/app/ads-block.html">
            как это сделать.
        </a>
    </span></li>
</ul>
};

my $separate_cpm_en = q {
<b style="color:#2F3747; font-size:21px;"><span>Separate CPM</span></b><br><br>
<span>
    The «Separate CPM» strategy will no longer be supported.
    For all blocks where this strategy has been set, we will set the «Auto CPM» strategy in its place.
    If necessary, you can change the strategy in the settings and set the minimum CPM.
    Please find attached a file with your blocks that this strategy is set.
</span><br><br>
};

my $brands_and_categories_en = q {
<b style="color:#2F3747; font-size:21px;"><span>Restrictions on brands and categories</span></b><br><br>
<span>
    <b style="color:#2F3747;">At the application level: </b>
    your settings for blocking by Bundle ID (for apps) or advertiser domains will be migrated.
    You can also set a restriction on categories at the application level.
</span><br><br>
<span>
    <b style="color:#2F3747;">At the ad block level: </b>
    these restrictions are no longer supported and won't be saved during migration.
    Please find attached a file listing your ad blocks and their restrictions on categories and brands.
    Immediately after migration, you can set restrictions at the application level: the settings will be applied to all its ad blocks.
    Read more about
    <a href="https://yandex.com/support/partner/inapp/app/ads-block.html?lang=en">
        how to do this.
    </a>
</span><br><br>
};

my $by_lang = {
    ru => {
        fields => [
            {
                field => 'public_id',
                name  => 'ID блока'
            },
            {
                field => 'media_cpm_ru',
                name  => 'Медиа CPM',
            },
            {
                field => 'text_cpm_ru',
                name  => 'Текст CPM'
            },
            {
                field => 'categories_ru',
                name  => 'Тематики'
            },
            {
                field => 'brands_ru',
                name  => 'Бренды'
            }
        ],
    },
    en => {
        fields => [
            {
                field => 'public_id',
                name  => 'Block ID'
            },
            {
                field => 'media_cpm_en',
                name  => 'Media CPM',
            },
            {
                field => 'text_cpm_en',
                name  => 'Text CPM'
            },
            {
                field => 'categories_en',
                name  => 'Categories'
            },
            {
                field => 'brands_en',
                name  => 'Brands'
            }
        ],
    }
};

no warnings 'redefine';

sub Utils::XLS::_add_payment_disclaimer {
    # чтобы убрать футер из эксельки
}

sub main {
    my ($app, $opts) = @_;

    my $users = $app->partner_db->_get_all(
        q[
        select
            u.id, login
        from users u
        join pages p on u.id = p.owner_id
        join context_on_site_rtb b on p.id = b.campaign_id
        where p.model = 'mobile_app_settings' and
        b.multistate & 1 = 0 and b.multistate & 8 = 0 and
        p.multistate & 8 = 0 and p.multistate & 128 = 0 and p.multistate & 4096 = 0 and (
            (p.id, b.id) in (
                select page_id, block_id from brands
                union all
                select page_id, block_id from picategories
            ) or b.strategy = 3
        )
        and u.email is not null and u.email != '' and
        u.multistate & 16 = 0 and
        u.id not in (select user_id from user_features where feature = 'simple_inapp')
        group by u.id;
    ]
    );

    foreach my $user (@$users) {
        my $data = $app->partner_db->_get_all(
            q[
            select
                concat('R-M-', p.id, '-', b.id) as public_id,
                group_concat(
                    distinct concat(
                        c.category_id, ' - ', cd.name_ru, ', ', if(c.cpm = 9999, 'заблокировано', concat('CPM: ', c.cpm))
                    ) order by c.category_id separator '; '
                ) as categories_ru,
                group_concat(
                    distinct concat(
                        c.category_id, ' - ', cd.name_en, ', ', if(c.cpm = 9999, 'blocked', concat('CPM: ', c.cpm))
                    ) order by c.category_id separator '; '
                ) as categories_en,
                group_concat(
                    distinct concat(
                        br.bid, ' - ', bd.name_ru, ', ', if(br.blocked, 'заблокировано', concat('CPM: ', br.cpm))
                    ) order by br.bid separator '; '
                ) as brands_ru,
                group_concat(
                    distinct concat(
                        br.bid, ' - ', bd.name_en, ', ', if(br.blocked, 'blocked', concat('CPM: ', br.cpm))
                    ) order by br.bid separator '; '
                ) as brands_en,
                case
                    when b.strategy != 3 then null
                    when b.media_blocked then 'заблокировано'
                    else concat('CPM: ', b.media_cpm)
                end as media_cpm_ru,
                case
                    when b.strategy != 3 then null
                    when b.media_blocked then 'blocked'
                    else concat('CPM: ', b.media_cpm)
                end as media_cpm_en,
                case
                    when b.strategy != 3 then null
                    when b.text_blocked then 'заблокировано'
                    else concat('CPM: ', b.text_cpm)
                end as text_cpm_ru,
                case
                    when b.strategy != 3 then null
                    when b.text_blocked then 'blocked'
                    else concat('CPM: ', b.text_cpm)
                end as text_cpm_en
            from users u
            join pages p on u.id = p.owner_id
            join context_on_site_rtb b on p.id = b.campaign_id
            left join picategories c on p.id = c.page_id and c.block_id = b.id
            left join picategories_dict cd on c.category_id = cd.category_id
            left join brands br on p.id = br.page_id and b.id = br.block_id
            left join tns_dict_brand bd on br.bid = bd.bid
            where u.id = ? and p.model = 'mobile_app_settings' and
            b.multistate & 1 = 0 and b.multistate & 8 = 0 and
            p.multistate & 8 = 0 and p.multistate & 128 = 0 and p.multistate & 4096 = 0
            and (
                b.strategy = 3 or c.block_id is not null or br.block_id is not null
            )
            group by p.id, b.id
            order by p.id, b.id;
        ], $user->{id},
        );
        print logstr("Got " . scalar(@$data) . " rows for user " . $user->{login} . " USER_ID " . $user->{id});

        my $has_separate_cpm         = grep {$_->{media_cpm_ru} || $_->{text_cpm_ru}} @$data;
        my $has_brands_or_categories = grep {$_->{brands_ru}    || $_->{categories_ru}} @$data;

        my $language = $app->get_user_lang($user->{id});
        $language = 'en' if $language ne 'ru';
        print logstr("Params for user "
              . $user->{login}
              . " language="
              . $language
              . " has_separate_cpm="
              . $has_separate_cpm
              . " has_brands_or_categories="
              . $has_brands_or_categories);

        my $excel = xls_with_fields_and_names($data, $by_lang->{$language}->{fields});

        print logstr("START sending to " . $user->{login} . " USER_ID " . $user->{id});
        send_letter($app, $user, $excel, $has_separate_cpm, $has_brands_or_categories);
    }
}

sub send_letter {
    my ($app, $user, $excel, $has_separate_cpm, $has_brands_or_categories) = @_;
    try {
        $app->mailer->send(
            'body' => {
                'content_type' => 'text/html',
                'template'     => 'mail_notification/complex_inapp.html.tt2',
                'type'         => 'TT2',
                'vars'         => {
                    'separate_cpm_ru'          => $has_separate_cpm         ? $separate_cpm_ru          : '',
                    'brands_and_categories_ru' => $has_brands_or_categories ? $brands_and_categories_ru : '',
                    'separate_cpm_en'          => $has_separate_cpm         ? $separate_cpm_en          : '',
                    'brands_and_categories_en' => $has_brands_or_categories ? $brands_and_categories_en : ''
                }
            },
            'content_type' => 'text/html',
            'from'         => 'default',
            'subject'      => 'Миграция в новый интерфейс | Migration to the new interface',
            'to'           => {user_id => $user->{id}},
            attachments    => {
                data     => $excel,
                filename => 'blocks.xls',
            }
        );
        print logstr("Send to '$user->{login}' success USER_ID " . $user->{id});
    }
    catch {
        my ($e) = @_;
        warn logstr("FAIL send to '$user->{login}' USER_ID '$user->{id}' : " . $e->message);
    };
}

run(\&main);

__END__
