#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

  Скрипт заполняет поле  "ignore_domain_check" у заданных мобильных пейджей

=head1 USAGE

perl bin/oneshots/PI-27311_set_ignore_domain_check_option.pl --file_path pages.txt --over_logs

=head1 OPTIONS

  - file_path  - файл с id страниц
  - unset      - флаг, что нужно не устанавливать, а снимать опцию ignore_domain_check

=cut

use strict;
use warnings;

use lib::abs qw(../../lib);

use qbit;
use Utils::ScriptWrapper 'oneshot';
use File::Slurp qw(read_file);

my %expected_model = map {$_ => TRUE} qw/mobile_app_settings internal_mobile_app/;

run(
    sub {
        my ($app, $opts) = @_;

        my @pages = read_file($opts->{file_path});
        chomp @pages;

        my %pages_not_found = map {$_ => TRUE} @pages;
        my %model_pages;

        for my $page (
            @{
                $app->all_pages->get_all(
                    filter => {page_id => \@pages},
                    fields => [qw/model id/]
                )
            }
          )
        {
            delete $pages_not_found{$page->{id}};
            if ($expected_model{$page->{model}}) {
                push @{$model_pages{$page->{model}} //= []}, $page->{id};
            } else {
                print logstr(ERROR => sprintf("Page %s has unexpected model %s", $page->{id}, $page->{model}));
            }
        }
        for my $page_id (keys %pages_not_found) {
            print logstr(ERROR => sprintf("Page %s not found", $page_id));
        }
        return if $opts->{dry_run};
        for my $model (keys %model_pages) {
            for my $page_id (@{$model_pages{$model}}) {
                $app->$model->do_action($page_id, edit => ignore_domain_check => ($opts->{unset} ? 0 : 1));
            }
        }

    }
   );

sub args {
    my ($opts) = @_;

    return (
        'file_path:s' => \$opts->{file_path},
        'unset!'      => \$opts->{set},
    );
}
