#!/usr/bin/perl

=encoding UTF-8

=cut

=head1 DESCRIPTION

    Конвертим блоки типа banner партнёров с фичей simple_inapp в direct_block=media_block=adaptive0418

=head1 USAGE

    bin/oneshots/PI-28728_update_adaptive_banners.pl --dry_run --over_logs

=head1 OPTIONS

    dry_run - Ничего не меняет, просто выводит то что хочет заменить

=cut

use lib::abs-soft => qw(
  ../../lib
  ../../local/lib/perl5/
  );

use qbit;
use PiConstants qw($TECHNICAL_RTB_BLOCK_ID);
use Utils::ScriptWrapper;
use File::Slurp qw(write_file);

run(\&main);

sub prepare_args {
    my ($opts) = @_;

    $opts->{ticket} ||= 'PI-27652';
}

sub main {
    my ($app, $opts) = @_;

    my $rtbs = fetch_blocks($app, $opts->{ignore});
    #format: {page_id=>[{campaign_id=> ..., id=>..., media_block=>...}, ...], ...}

    my @pages_to_resend;

    for my $page_id (keys %$rtbs) {
        push @pages_to_resend, $page_id if process_page($app, $page_id, $rtbs->{$page_id}, $opts);
    }
    if (@pages_to_resend) {
        my $filename = 'updated_pages.log';
        write_file($filename, @pages_to_resend);

        print logstr("blocks updated, you may want to run:"),
          logstr("bin/resend_to_bk.pl --logbroker_only 1 --split 10 --file_path=$filename 2>&1 | tee resend_to_bk.log");
    }
}

sub process_page {
    my ($app, $page_id, $rtbs, $opts) = @_;

    my $msg = 'UPDATE_BLOCK';
    $msg = 'DRY_RUN' if $opts->{dry_run};

    my %opt_val = (
        limit                => undef,
        callouts             => undef,
        font_size            => undef,
        title_font_size      => undef,
        url_background_color => undef,
        font_family          => undef,
        #        adaptive_height => '',#        Настройка "adaptive_height" только для настраиваемого, горизонтального и motion блока (23)
        #        adaptive_width => '',#         Настройка "adaptive_width" только для адаптивного блока (13)
        title_color => "0000CC",
        url_color   => "006600",
        hover_color => "DD0000",
        #sitelinks_color => "0000CC",
        text_color      => "000000",
        border_type     => "none",
        links_underline => 1,
        favicon         => 1,
        site_bg_color   => "FFFFFF",
        no_sitelinks    => 0,
    );

    try {
        $app->partner_db->transaction(
            sub {
                for my $block (@$rtbs) {
                    my %data = (
                        direct_block => 'adaptive0418',
                        media_block  => 'adaptive0418',
                    );
                    my $block_opts    = from_json($block->{opts});
                    my $need_opts_upd = FALSE;
                    for (keys %opt_val) {
                        if (defined $opt_val{$_} && !defined $block_opts->{$_}) {
                            $block_opts->{$_} = $opt_val{$_};
                            print "val=$_\n";
                            $need_opts_upd = 1;
                        } elsif (!defined $opt_val{$_} && defined $block_opts->{$_}) {
                            undef $block_opts->{$_};
                            print "undef $_\n";
                            $need_opts_upd = 1;
                        }
                    }
                    for (qw/adaptive_height adaptive_width/) {
                        if (defined $block_opts->{$_} && $block_opts->{$_} ne '') {
                            $block_opts->{$_} = '';
                            print "val=$_\n";
                            $need_opts_upd = 1;
                        }
                    }
                    if ($block_opts->{no_sitelinks} && defined $block_opts->{sitelinks_color}) {
                        undef $block_opts->{sitelinks_color};
                        print "undef sitelinks_color\n";
                        $need_opts_upd = 1;
                    } elsif ($block_opts->{no_sitelinks} == 0 && !defined $block_opts->{sitelinks_color}) {
                        $block_opts->{sitelinks_color} = "0000CC";
                        print "val=sitelinks_color\n";
                        $need_opts_upd = 1;
                    }
                    $data{opts} = to_json($block_opts) if $need_opts_upd;
                    print logstr(
                        sprintf '%s: <%s>:<%s> direct=<%s> media=<%s> opts=<%s>',
                        $msg,
                        @$block{qw/campaign_id id direct_block media_block/},
                        $need_opts_upd ? $block->{opts} : ''
                    );
                    next if $opts->{dry_run};
                    $app->mobile_app_rtb->partner_db_table->edit($block, \%data);
                    my $filter = $app->partner_db->filter({page_id => $block->{campaign_id}, block_id => $block->{id}});
                    $app->partner_db->media_sizes->delete($filter);
                    $app->partner_db->media_sizes->add(
                        {page_id => $block->{campaign_id}, block_id => $block->{id}, type => $data{media_block}});
                    my ($is_valid, $dtl) = run_qbit_validator_for_block($app, $page_id, $block->{id});

                    unless ($is_valid) {
                        print logstr($dtl);
                        throw Exception::Validation("validation problem for $page_id");
                    }
                }
            }
        );
    }
    catch Exception::Validation with {
        print logstr"error processing page $page_id";
        return FALSE;
    };
    return TRUE;
}

sub fetch_blocks {
    my ($app) = @_;

    my $blocks = $app->partner_db->_get_all(<<"SQL");
        SELECT campaign_id,
               b.id,
               b.direct_block,
               b.media_block,
               b.opts
        FROM context_on_site_rtb b
          JOIN mobile_app_settings s ON s.context_page_id = b.campaign_id
          JOIN user_features f
            ON f.user_id = s.owner_id
           AND f.feature = 'simple_inapp'
        WHERE model = 'mobile_app_rtb'
        AND   b.block_type = 'banner'
        AND   b.multistate & 9 = 0
        AND   (b.direct_block != 'adaptive0418' OR b.media_block != 'adaptive0418')
SQL

    my %result;
    for my $block (@$blocks) {
        my $page = $block->{campaign_id};
        push @{$result{$page} //= []}, $block;
    }
    return \%result;
}

# based on copy&paste from ./bin/fix_page_id.pl
sub run_qbit_validator_for_block {
    my ($app, $page_id, $block_id) = @_;

    my $model        = $app->mobile_app_rtb();
    my $model_fields = $model->get_model_fields;
    my %pk           = map {$_ => TRUE} grep {$model_fields->{$_}{'pk'}} keys(%$model_fields);

    my @ignore_fields = $app->qbit_validator_checker->_get_field_names_to_ignore('mobile_app_rtb');
    my $fields = arrays_difference([keys(%$model_fields)], \@ignore_fields);

    next if $block_id == $TECHNICAL_RTB_BLOCK_ID;

    my $pk_value = {
        campaign_id => $page_id,
        id          => $block_id,
    };

    my $block_data = $model->get_all(
        fields => array_uniq(@$fields, keys(%pk)),
        filter => $pk_value,
    )->[0];

    my $qv = QBit::Validator->new(
        data => $block_data,
        app  => $model,
        $model->get_template(fields => $fields, values => $pk_value),
    );

    if ($qv->has_errors) {
        my @fields_with_errors = $qv->get_fields_with_error();

        my %error_fields;
        foreach my $f (@fields_with_errors) {
            #pk поля как правило проверяются при добавлении get_all_campaigns_for_adding
            #затем площадка может быть удалена или находиться в другом статусе.
            my $field_name = $f->{'path'}[0] // 'ERROR_IN_ROOT';

            next if $pk{$field_name};

            $error_fields{$field_name} = {
                msg   => join('; ', @{$f->{'msgs'}}),
                value => $block_data->{$field_name},
                path  => $f->{'path'},
            };
        }
        my $details = {};
        if (%error_fields) {
            my $data = {
                pk           => $pk_value,
                error_fields => \%error_fields,
            };
            push @{$details->{error_elements} //= []}, $data;
        } else {
            die 'this should never happen';
        }
        return FALSE, $details;
    } else {
        return TRUE;
    }

}
