#!/usr/bin/perl

=encoding UTF-8

=cut

=head1 DESCRIPTION

    нужно подключить прод баланс

=head1 USAGE

    ./bin/oneshots/PI-28775/PI-28775_update_partner_requisites.pl --ticket=PI-28775 --operator_uid=649887323
    649887323 - yndx-robot-partner

=head1 OPTIONS

=cut

use lib::abs-soft => qw(
  ../../../lib
  ../../../local/lib/perl5/
  );

use qbit;
use Utils::ScriptWrapper;
use Utils::CSV;

sub args {
    my ($opts) = @_;

    return ('operator_uid:s' => \$opts->{'operator_uid'},);
}

sub main {
    my ($app, $opts) = @_;

    my $operator_uid = $opts->{'operator_uid'};

    unless ($operator_uid) {
        die("operator_uid is required");
    }

    my $prev_logs            = readfile("$opts->{file_name}.out");
    my @skip_client_ids      = ($prev_logs =~ m/Successfully updated client_id\s+(\d+)/g);
    my $skip_client_ids_hash = {};
    for my $skip_client_id (@skip_client_ids) {
        $skip_client_ids_hash->{$skip_client_id} = 1;
    }

    @skip_client_ids = ($prev_logs =~ m/No update required for client_id\s+(\d+)/g);
    for my $skip_client_id (@skip_client_ids) {
        $skip_client_ids_hash->{$skip_client_id} = 1;
    }

    print logstr('Client_ids to be skipped', $skip_client_ids_hash);

    my @errors;
    push @errors, update_by_file($app, "bin/oneshots/PI-28775/list_3.csv", $operator_uid, $skip_client_ids_hash);
    push @errors, update_by_file($app, "bin/oneshots/PI-28775/list_2.csv", $operator_uid, $skip_client_ids_hash);
    push @errors, update_by_file($app, "bin/oneshots/PI-28775/list_1.csv", $operator_uid, $skip_client_ids_hash);

    if (@errors) {
        print logstr('Errors client_ids', \@errors);
        die('Has errors');
    }
}

sub update_by_file {
    my ($app, $filename, $operator_uid, $skip_client_ids_hash) = @_;
    print logstr('Update by file', $filename);
    my $file_content     = readfile($filename);
    my @error_client_ids = ();
    for my $expected_data (@{parse_csv($file_content, sep_char => ";")}) {
        print logstr('Read', $expected_data);
        my $client_id = $expected_data->{client_id};
        if ($skip_client_ids_hash->{$client_id}) {
            print logstr('Skip UPDATE client_id', $client_id);
            next;
        }

        my $contract_id = $expected_data->{contract_id};
        my $person_id   = $expected_data->{person_id};

        my $contracts = undef;
        try {
            $contracts = $app->api_balance->get_partner_contracts("ClientID" => $client_id);
        }
        catch {
            my ($e) = @_;
            print logstr('ERROR during GET client_id', $client_id, $e->message);
            push @error_client_ids, $client_id;
        };
        if (not defined($contracts)) {
            next;
        }

        my $filtered_contracts = [
            grep {
                      defined($_->{Contract}->{contract2_id})
                  and "$_->{Contract}->{contract2_id}" eq $contract_id
                  and defined($_->{Contract}->{person_id})
                  and "$_->{Contract}->{person_id}" eq $person_id
              } @$contracts
        ];

        unless (@$filtered_contracts) {
            print logstr('ERROR. Not found data for update', $contracts);
            push @error_client_ids, $client_id;
            next;
        }

        my $contract = $filtered_contracts->[0];
        print logstr('Start update', $contract);
        my $account        = $contract->{Person}->{account};
        my $person_account = $contract->{Person}->{person_account};

        my %opts = ();
        if (not defined($account) or $account ne $expected_data->{person_account}) {
            print logstr('Update account to', $expected_data->{person_account});
            $opts{account} = $expected_data->{person_account};
        }

        if ($person_account) {
            print logstr('Update person_account to NULL');
            $opts{person_account} = undef;
        }

        if (%opts) {
            try {
                $app->api_balance->create_person(
                    operator_uid => $operator_uid,
                    client_id    => $client_id,
                    person_id    => $person_id,
                    type         => $contract->{Person}->{type},
                    %opts
                );
                print logstr('Successfully updated client_id', $client_id);
            }
            catch {
                my ($e) = @_;
                print logstr('ERROR during UPDATE client_id', $client_id, $e->message);
                push @error_client_ids, $client_id;
            };
        } else {
            print logstr('No update required for client_id', $client_id);
        }

    }
    return @error_client_ids;
}

run(\&main);
