#!/usr/bin/perl

=encoding UTF-8

=cut

=head1 DESCRIPTION

    нужно подключить прод баланс

=head1 USAGE

    ./bin/oneshots/PI-28775/fix_after_PI-28775_update_partner_requisites.pl --ticket=PI-28775 --operator_uid=649887323 --file_path=PI-28775_update_partner_requisites.out
    file_path - путь к логу от запуска скрипта PI-28775_update_partner_requisites.pl лежит тут https://st.yandex-team.ru/PI-28775#628262f983d163284fa251fa
    649887323 - yndx-robot-partner

=head1 OPTIONS

=cut

use lib::abs-soft => qw(
  ../../../lib
  ../../../local/lib/perl5/
  );

use qbit;
use Utils::ScriptWrapper;
use Utils::CSV;

sub args {
    my ($opts) = @_;

    return (
        'operator_uid:s' => \$opts->{'operator_uid'},
        'file_path:s'    => \$opts->{'file_path'},
    );
}

sub main {
    my ($app, $opts) = @_;

    my $operator_uid = $opts->{'operator_uid'};

    unless ($operator_uid) {
        die("operator_uid is required");
    }

    my $file_path = $opts->{'file_path'};

    unless ($file_path) {
        die("file_path is required");
    }

    my $prev_logs            = readfile("$opts->{file_name}.out");
    my @skip_client_ids      = ($prev_logs =~ m/Successfully updated client_id\s+(\d+)/g);
    my $skip_client_ids_hash = {};
    for my $skip_client_id (@skip_client_ids) {
        $skip_client_ids_hash->{$skip_client_id} = 1;
    }

    @skip_client_ids = ($prev_logs =~ m/No update required for client_id\s+(\d+)/g);
    for my $skip_client_id (@skip_client_ids) {
        $skip_client_ids_hash->{$skip_client_id} = 1;
    }

    print logstr('Client_ids to be skipped', $skip_client_ids_hash);

    my $file_content = readfile($file_path);

    my @error_client_ids = ();
    while ($file_content =~ /\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2} - Start update\s+(.+)/g) {
        my $contract = from_json($1);
        if ($skip_client_ids_hash->{$contract->{Person}->{client_id}}) {
            print logstr('Skip UPDATE client_id', $contract->{Person}->{client_id});
            next;
        }

        print logstr('Start update', $contract);
        my %opts = ();
        $opts{operator_uid} = $operator_uid;
        $opts{client_id}    = $contract->{Person}->{client_id};
        $opts{person_id}    = $contract->{Person}->{id};
        $opts{type}         = $contract->{Person}->{type};
        $opts{bank_type} = 2;    # https://st.yandex-team.ru/PI-28775#628753b96d6d371fc21dd66b
        $opts{is_partner} = $contract->{Person}->{is_partner};
        $opts{bik}        = $contract->{Person}->{bik};

        print logstr('Data for update', \%opts);

        try {
            $app->api_balance->create_person(%opts);
            print logstr('Successfully updated client_id', $opts{client_id});
        }
        catch {
            my ($e) = @_;
            print logstr('ERROR during UPDATE client_id', $opts{client_id}, $e->message);
            push @error_client_ids, $opts{client_id};
        };
    }

    if (@error_client_ids) {
        print logstr('Errors client_ids', \@error_client_ids);
        die('Has errors');
    }
}

run(\&main);
