#!/usr/bin/perl

use feature 'say';
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use Text::CSV;
use File::Temp qw(tempfile);
use Data::Dumper;

{
    no warnings 'redefine';
    *QBit::Application::check_rights = sub {1};
}

sub main {

    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});

    my @fields = map {$_->{name}} @{$app->partner_db->context_on_site_adfox->fields()};

    my $intersection_file = $ARGV[0] // die 'Please supply a path to file with intersection as a first argument';
    open(my $intersection_fh, '<', $intersection_file) or die "open intersection: $!";

    my $tsv = Text::CSV->new({binary => 1, sep_char => "\t", eol => "\n", escape_char => undef, quote_char => undef});
    my $header = $tsv->getline($intersection_fh);
    die "Wrong number of columns in intersection file" unless @$header == 2;

    my ($mapping_fh, $mapping_file) = tempfile('PI_10286_mapping_XXXXXX', DIR => lib::abs::path('../../'));
    $tsv->print($mapping_fh, [qw(page_id old_block_id new_block_id)]);

    my %blocks;

    while (my $row = $tsv->getline($intersection_fh)) {
        my ($page_id, $block_id) = @$row;
        $app->partner_db->transaction(
            sub {
                my $new_block_id = $app->context_on_site_campaign->get_next_block_id($page_id);
                my $block = $app->partner_db->context_on_site_adfox->get({campaign_id => $page_id, id => $block_id},
                    fields => \@fields);
                $block->{id} = $new_block_id;
                $app->partner_db->context_on_site_adfox->add($block);
                my $dsps = $app->partner_db->context_on_site_adfox_dsps->get_all(
                    filter => {campaign_id => $page_id, block_id => $block_id},
                    fields => {
                        campaign_id => 'campaign_id',
                        block_id    => \$new_block_id,
                        dsp_id      => 'dsp_id',
                        is_deleted  => 'is_deleted',
                    },
                );
                $app->partner_db->context_on_site_adfox_dsps->add_multi($dsps);
                my $dsp_blocks = $app->partner_db->context_on_site_adfox_dsp_blocks->get_all(
                    filter => {campaign_id => $page_id, block_id => $block_id},
                    fields => {
                        campaign_id => 'campaign_id',
                        block_id    => \$new_block_id,
                        type        => 'type',
                    },
                );
                $app->partner_db->context_on_site_adfox_dsp_blocks->add_multi($dsp_blocks);
                $blocks{$page_id} //= [];
                push @{$blocks{$page_id}}, {$block_id => $new_block_id};
            }
        );
    }

    close($intersection_fh) or die "close intersection: $!";

    for my $page (
        @{$app->context_on_site_campaign->get_all(filter => {page_id => [keys(%blocks)]}, fields => [qw(id page_id)])})
    {
        try {
            $app->context_on_site_campaign->do_action($page->{id}, 'set_need_update');
            $app->context_on_site_campaign->update_in_bk({id => $page->{id}});

            for my $block_id (@{$blocks{$page->{page_id}}}) {
                my ($old_block_id, $new_block_id) = %$block_id;
                $app->partner_db->context_on_site_adfox->edit({campaign_id => $page->{page_id}, id => $old_block_id},
                    {is_custom_bk_data => 1});
                $app->partner_db->context_on_site_adfox->edit({campaign_id => $page->{page_id}, id => $new_block_id},
                    {is_custom_bk_data => 1});
                $tsv->print($mapping_fh, [$page->{page_id}, $old_block_id, $new_block_id]);
            }
        }
        catch {
            my ($e) = @_;
            say Dumper($page);
            say $e->message;
        };
    }

    close($mapping_fh) or die "close mapping: $!";

    say "Mapping file - $mapping_file";
}

main();
